package track.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.util.Date;

@Entity
public class Channel {

	private Long id;
	private String name;
	private Long account;
	private String category;
	private String url;
	private Date pubDate=new Date();
	private String type;
	private String uniqueName;
	private String firstchar;
	private boolean ishttps=false;
	private String os;
	private String trackurl = "http://uri6.com/$surl";
	private String androidparam;
	private String iosparam;
	private boolean istrackurlspecial=false;
	private Integer orderindex;
	
	private boolean isintegrate = false;

	//0 正常渠道  1 被合并渠道，不再显示
	private Boolean hidden = false;

	public Channel() {
		super();
	}

	public Channel(String name, String category, String url) {
		super();
		this.name = name;
		this.category = category;
		this.url = url;

	}

	public Long getAccount() {
		return account;
	}

	public String getCategory() {
		return category;
	}

	@Id
	@GeneratedValue
	public Long getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public Date getPubDate() {
		return pubDate;
	}

	public String getUrl() {
		return url;
	}

	public void setAccount(Long account) {
		this.account = account;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setPubDate(Date pubDate) {
		this.pubDate = pubDate;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getUniqueName() {
		return uniqueName;
	}

	public void setUniqueName(String uniqueName) {
		this.uniqueName = uniqueName;
	}

	public String getFirstchar() {
		return firstchar;
	}

	public void setFirstchar(String firstchar) {
		this.firstchar = firstchar;
	}

	public boolean isIshttps() {
		return ishttps;
	}

	public void setIshttps(boolean ishttps) {
		this.ishttps = ishttps;
	}

	public String getOs() {
		return os;
	}

	public void setOs(String os) {
		this.os = os;
	}

	public String getTrackurl() {
		return trackurl;
	}

	public void setTrackurl(String trackurl) {
		this.trackurl = trackurl;
	}
	

	public String getAndroidparam() {
		return androidparam;
	}

	public void setAndroidparam(String androidparam) {
		this.androidparam = androidparam;
	}

	public String getIosparam() {
		return iosparam;
	}

	public void setIosparam(String iosparam) {
		this.iosparam = iosparam;
	}

	public boolean isIstrackurlspecial() {
		return istrackurlspecial;
	}

	public void setIstrackurlspecial(boolean istrackurlspecial) {
		this.istrackurlspecial = istrackurlspecial;
	}

	public boolean isIsintegrate() {
		return isintegrate;
	}

	public Integer getOrderindex()
	{
		return orderindex;
	}

	public void setOrderindex(Integer orderindex)
	{
		this.orderindex = orderindex;
	}

	public void setIsintegrate(boolean isintegrate) {
		this.isintegrate = isintegrate;
	}

	public Boolean getHidden() {
		return hidden;
	}

	public void setHidden(Boolean hidden) {
		this.hidden = hidden;
	}
}
