package userio.repository;


import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;
import userio.model.RoleAuth;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;


public interface IORoleAuthRepository extends JpaRepository<RoleAuth, Long> {

	RoleAuth findByRoleCategory(Long id);

    @Query(value = "select * from role_auth where id in ?1 ", nativeQuery = true)
    List<RoleAuth> findCustomRoleList(List<Long> createAccounts);

    @Query(value = "select * from role_auth where create_account in ?1 and del_flag is not true order by create_time desc ", nativeQuery = true)
    List<RoleAuth> findAllCustomRoleList(List<Long> createAccounts);

    @Query(value = "select count(*) from role_auth where create_account in ?1 and role_name = ?2 and del_flag is not true", nativeQuery = true)
    BigInteger findByAccountAndName(List<Long> accountList, String roleName);

    @Query(value = "select count(*) from role_auth where create_account in ?1 and role_category = 4 and del_flag is not true", nativeQuery = true)
    BigInteger findCustomNumByAccount(List<Long> accountList);

    @Transactional
    @Modifying
    @Query(value = "update role_auth set del_flag = true , modify_account = ?2, modify_time = ?3 where id = ?1 ", nativeQuery = true)
    int deleteCustomRole(Long roleId, Long modifyAccount, Date modifyDate);
}
