package userio.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;
import userio.model.SalesManLeader;

import java.util.List;

@Transactional
public interface IOSalesManLeaderRepository extends JpaRepository<SalesManLeader, Integer> {
    @Query(value = "select email from sales_man_leader where id=(select leader from sales_man_leader where id=?1)", nativeQuery = true)
    String findLeaderByBussinessMan(Long bussinessMan);

    @Query(value = "select * from sales_man_leader where leader = (select id from sales_man_leader where email = ?1)", nativeQuery = true)
    List<SalesManLeader> findByEmail(String email);

    @Query(value = "select * from sales_man_leader where email = ?1", nativeQuery = true)
    SalesManLeader findOneByEmail(String email);

    @Query(value = "select * from sales_man_leader where email in ?1", nativeQuery = true)
    List<SalesManLeader> findAllByEmails(List<String> emails);
}
