package userio.task;

import common.model.Contract;
import common.repository.ContractRepository;
import dic.ContractTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import userio.model.Account;
import userio.repository.IOAccountRepository;
import util.DateUtil;
import util.ValidateUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mxq on 2018/4/23.
 */
public class IOAccountCheck {
    @Autowired
    IOAccountRepository accountRepository;
    @Autowired
    ContractRepository contractRepository;

    public void task(){
        List<Account> accountList = accountRepository.findRootParentsByPubDate(DateUtil.getBeforeDays(30));
        if(ValidateUtil.isValid(accountList)){
            List<Account> list = new ArrayList<>();
            for(Account a: accountList){
                List<Contract> contractList = contractRepository.findByPlatformAndEmail("io", a.getEmail(), ContractTypeEnum.MAIN.getKey());
                if(null == contractList){
                    a.setStatus(0);
                    list.add(a);
                }

                if(ValidateUtil.isValid(list)){
                    accountRepository.save(list);
                }
            }


        }
    }
}
