package util;

/**
 * Created by nolan on 15/11/2016.
 * description:
 */
public enum ResultStatus {
    SUCCESS(200, "成功"),
    FAILED(-200, "失败"),
    NUMBER_LIMIT(-300, "超过限定值,无法添加"),
    NETWORK_ERROR(404, "网络异常"),
    PARAM_INVALID(-1000, "参数错误"),
    USER_EMPTY(-1001, "用户不存在"),
    USERNAME_LOGIN_EXPIRE(-1002, "用户登陆失效"),
    SUB_ACCOUNT_DISABLE(-1003, "子帐号已禁用"),
    ORIGINAL_ACCOUNT_DISABLE(-1004, "主体帐号已禁用"),
    ACCOUNT_BUSINESS_EXPIRE(-1005, "主帐号已过期"),
    ACCOUNT_NOT_CONFIRM(-1006, "帐号待审核"),
    APP_DEL(-1007, "应用已被删除"),
    AUTH_ACCOUNT_BUSINESS_EXPIRE(-1008, "授权帐号已过期"),
    ONELINK_OCCUPY(-1009, "onelink占用推广活动"),
    ACCOUNT_NOT_ACTIVATE(-1010, "账号未激活"),
    USER_NOT_AUTH(-2000, "功能未授权"),
    CAMPAIGN_CREATEING(-3000, "推广活动正在创建中, 请勿重复提交"),
    ID_NOT_EXIST(-4000, "对应ID的记录不存在"),
    EXPORT_DATA_EXIST(-5000, "导出记录已存在"),
    EXPORT_FILE_EXIST(-5001, "导出文件不存在"),
    RECORD_EXIST(-6000, "记录已存在,请勿重复提交"),
    NAME_EXIST(-6001, "名称已存在"),
    EVENT_NULL(-6002, "事件为空"),
    FILE_TYPE_ERROR(-6003, "文件格式错误"),

    CAMPAIGN_OCCUPY(-1010, "推广活动占用渠道"),


    NAME_NULL(-1101, "名称为空"),
    NAME_INVAILD(-1102, "名称不合法"),
    CAMPAIGN_NOT_MATCH_APP(-1103, "推广活动与应用不匹配"),
    SURL_NULL(-1105, "短链为空"),
    CAMPAIGN_NULL(-1106, "推广活动不存在"),
    CAMPAIGN_EXISTS(-1107, "此分包渠道的活动已存在"),
    CAMPAIGN_REPEAT(-1008, "批量创建推广活动时名称重复"),

    MSG_SMS_OUTOFTIME(-4001, "验证码过时，重新获取"),
    MSG_SMS_REQUESTTIMES(-4002, "今天请求验证码次数过多"),
    MSG_SMS_IPREQUESTTIMES(-4003, "IP地址请求过多"),
    MSG_SMS_IPERROR(-4004, "未知ip达到峰值"),
    MSG_SMS_WRONG(-4005, "验证码不正确"),

    CHANNELACCOUNT_NOEXIST(-5001, "渠道帐号不存在"),
    CHANNEL_ALIASNAME_EXIST(-5002, "该名称系统已存在"),
    CHANNELACCOUNT_EXIST(-5003, "该账号ID已创建投放账号，不可重复创建"),
    CHANNEL_LINKID_NOEXIST(-5004, "link_id不存在"),
    COMMON_IP_EXISTS(-7000, "公共ip已存在"),
    EXP_INVALID(11000, "自定义表达式错误"),
    NONE_FILE_EXIST(-1000, "上传文件为空"),
    FORMAT_FILE_ERRO(-10001, "模板文件格式错误"),
    UPLOAD_CONTENT_ERRO(-10002, "模板文件内容错误");


    /**
     * 返回码
     */
    private int code;

    /**
     * 返回结果描述
     */
    private String message;

    ResultStatus(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}