package common.repository;

import common.model.Contract;
import common.model.ContractChange;
import common.model.ContractMoney;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigInteger;
import java.util.List;

@Transactional
public interface ContractChangeRepository extends JpaRepository<ContractChange, Long> {

    @Query(value="select * from contract_change where ds >= ?1 and ds <= ?2 and contract_code = ?3 order by ds desc",nativeQuery=true)
    List<ContractChange> findByDs(String startDate, String endDate, String code);

    @Query(value="SELECT * from contract_change where platform = ?1 and email = ?2 and ds >= ?3 and ds <= ?4 order by ds desc",nativeQuery=true)
    List<ContractChange> findByPlatformAndEmail(String platform, String email, String startDate, String endDate);

}
