package common.repository;

import common.model.Contract;
import common.model.Role;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigInteger;
import java.util.List;

@Transactional
public interface ContractRepository extends JpaRepository<Contract, Long> {

    @Query(value="select count(*) from contract where ds = ?1",nativeQuery=true)
    BigInteger countNumByDs(String ds);

    @Query(value="select count(*) from contract where email = ?1 and platform = ?2",nativeQuery=true)
    BigInteger countNumByEmail(String email, String platfrom);

    @Query(value="select * from contract where start_date >= ?1 and start_date <= ?2 and platform = ?3 order by ds desc",nativeQuery=true)
    List<Contract> findByDs(String startDate, String endDate, String platfrom);

    @Query(value="select * from contract where start_date >= ?1 and start_date <= ?2 and platform = ?3 and sale in ?4 order by ds desc",nativeQuery=true)
    List<Contract> findByDsAndRoile(String startDate, String endDate, String platfrom, List<Long> userids);

    @Query(value="select * from contract where contract_code = ?1",nativeQuery=true)
    Contract findByCode(String contract_code);

    @Query(value="SELECT * from contract where platform = ?1",nativeQuery=true)
    List<Contract> findByPlatform(String platform);

    @Query(value="SELECT * from contract where platform = ?1 and email = ?2 and type = ?3",nativeQuery=true)
    List<Contract> findByPlatformAndEmail(String platform, String email, String type);

    @Query(value="SELECT * from contract where platform = ?1 and email = ?2 and type = ?3 order by ds desc limit 1",nativeQuery=true)
    Contract findByPlatformAndEmailLimit1(String platform, String email,String type);

    @Query(value="SELECT * from contract where platform = ?1 and email = ?2 and type = ?3 and price_level = ?4 order by ds desc limit 1",nativeQuery=true)
    Contract findByPlatformAndEmailAndPricelevelLimit1(String platform, String email,String type, Long priceLevel);

    @Query(value="SELECT * from contract where platform = ?1 and email = ?2 and (status = 'wait' or status = 'executing') and type = 'main' order by ds desc limit 1",nativeQuery=true)
    Contract findByPlatformAndEmailLimitVaild(String platform, String email);

    @Query(value="SELECT * from contract where start_date = ?1  and status <> 'cancel'",nativeQuery=true)
    List<Contract> findByStartDate(String startDate);

    @Query(value="SELECT * from contract where end_date <= ?1 and (status <> 'end' or status <> 'cancel')",nativeQuery=true)
    List<Contract> findByEndDate(String endDate);
}
