package common.repository;

import common.model.Account4Web;
import common.model.IOAccount4Web;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public interface IOAccount4WebRepository extends JpaRepository<IOAccount4Web, Long> {

    @Query(value = "SELECT * from account4web where email in ?1", nativeQuery = true)
    List<IOAccount4Web> findByEmails(List<String> emails);

    @Query(value = "SELECT * from account4web where past_date = ?1", nativeQuery = true)
    List<IOAccount4Web> findByPast(String yesterday);

    @Query(value = "SELECT * from account4web where status = '已过期' or status = '流量用尽'", nativeQuery = true)
    List<IOAccount4Web> findPast();

    @Query(value = "SELECT * from account4web where email = ?1", nativeQuery = true)
    IOAccount4Web findByEmail(String email);

}
