package common.repository;


import common.model.Notice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public interface NoticeRepository extends JpaRepository<Notice, Long> {

    @Query(value="select * from notice where user = ?1 and ds >= ?2 order by ds desc",nativeQuery=true)
    List<Notice> findall(Long user, String ds);

    @Query(value="select * from notice where user = ?1",nativeQuery=true)
    List<Notice> findall(Long user);
}
