package security;

/**
 * Created by sunhao on 17/3/3.
 */
public interface RedisLoginStatusManager {

    /**
     * 根据token和状态在redis中创建登陆状态
     */
    void createLoginStatus(String token, String status);

    /**
     * 根据token删除登陆状态
     */
    void deleteLoginStatus(String token);

    /**
     * 根据token获取登陆密码
     */
    String getLoginPassword(String token);

    /**
     * 根据token获取登陆状态
     */
    boolean getLoginStatusByKey(String token);

}
