package tkio.repository;


import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import tkio.model.App;
import tkio.model.IncrementFlow;

import java.math.BigInteger;
import java.util.List;

public interface IncrementFlowRepository extends JpaRepository<IncrementFlow, Long> {

	@Query(value = "select count(flow) from increment_flow where account = ?1 and end_date > ?2", nativeQuery = true)
	BigInteger listByRootAccount(Long account, String ds);

	@Query(value = "select * from increment_flow where contract_code = ?1", nativeQuery = true)
	IncrementFlow findOne(String code);

	@Query(value = "select appkey from app where account  in ?1", nativeQuery = true)
	List<String> findAppkeys(List<Long> accountId);
}
