package track.model;

import javax.persistence.*;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Entity
public class Account {

	private Long id;
	private String email;
	private String password;
	private String company;
	private String name;
	private String phone;
	private String qq;
	private boolean isSuperUser;
	private boolean isActive=true;
	private Long parent = (long) 0;
	private Date pubDate = new Date();
	private String isSpecialAccount;
	private int status;
	private Integer type; //帐户类型: SA(1)
	
	private Long roleid;

	private List<String> authPermissions;

	private List<Map<String, String>> ChannelPermissions;
	
	private List<Map<String, String>> campaignPermissions;
	
	private String pastDate;
	private String remark;

	@Transient
	public List<String> getAuthPermissions() {
		return authPermissions;
	}

	public void setAuthPermissions(List<String> authPermissions) {
		this.authPermissions = authPermissions;
	}
	
	
	@Transient
	public List<Map<String, String>> getCampaignPermissions() {
		return campaignPermissions;
	}

	public void setCampaignPermissions(List<Map<String, String>> campaignPermissions) {
		this.campaignPermissions = campaignPermissions;
	}

	@Transient
	public List<Map<String, String>> getChannelPermissions() {
		return ChannelPermissions;
	}

	public void setChannelPermissions(
			List<Map<String, String>> channelPermissions) {
		ChannelPermissions = channelPermissions;
	}

	public Account() {
		super();
	}

	public Account(String email, String password, String company, String name,
			String phone, String qq, boolean isSuperUser, boolean isActive) {
		super();
		this.email = email;
		this.password = password;
		this.company = company;
		this.name = name;
		this.phone = phone;
		this.qq = qq;
		this.isSuperUser = isSuperUser;
		this.isActive = isActive;
	}

	public String getCompany() {
		return company;
	}

	public String getEmail() {
		return email;
	}

	@Id
	@GeneratedValue
	public Long getId() {
		return id;
	}

	public boolean getIsSuperUser() {
		return isSuperUser;
	}

	public String getName() {
		return name;
	}

	public String getPassword() {
		return password;
	}

	public String getPhone() {
		return phone;
	}

	public Date getPubDate() {
		return pubDate;
	}

	public String getQq() {
		return qq;
	}

	public boolean isActive() {
		return isActive;
	}

	public void setActive(boolean isActive) {
		this.isActive = isActive;
	}

	public void setCompany(String company) {
		this.company = company;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public void setIsSuperUser(boolean isSuperUser) {
		this.isSuperUser = isSuperUser;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public void setPubDate(Date pubDate) {
		this.pubDate = pubDate;
	}

	public void setQq(String qq) {
		this.qq = qq;
	}

	public void setSuperUser(boolean isSuperUser) {
		this.isSuperUser = isSuperUser;
	}

	public Long getParent() {
		return parent;
	}

	public void setParent(Long parent) {
		this.parent = parent;
	}

	public String getIsSpecialAccount() {
		return isSpecialAccount;
	}

	public void setIsSpecialAccount(String isSpecialAccount) {
		this.isSpecialAccount = isSpecialAccount;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public Long getRoleid() {
		return roleid;
	}

	public void setRoleid(Long roleid) {
		this.roleid = roleid;
	}

	public String getPastDate() {
		return pastDate;
	}

	public void setPastDate(String pastDate) {
		this.pastDate = pastDate;
	}

	@Column(length=28)
	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}


	@Override
	public String toString() {
		return "Account{" +
				"authPermissions=" + authPermissions +
				", campaignPermissions=" + campaignPermissions +
				", ChannelPermissions=" + ChannelPermissions +
				", company='" + company + '\'' +
				", email='" + email + '\'' +
				", id=" + id +
				", isActive=" + isActive +
				", isSpecialAccount='" + isSpecialAccount + '\'' +
				", isSuperUser=" + isSuperUser +
				", name='" + name + '\'' +
				", parent=" + parent +
				", password='" + password + '\'' +
				", pastDate='" + pastDate + '\'' +
				", phone='" + phone + '\'' +
				", pubDate=" + pubDate +
				", qq='" + qq + '\'' +
				", remark='" + remark + '\'' +
				", roleid=" + roleid +
				", status=" + status +
				", type=" + type +
				'}';
	}
}
