package track.repository;


import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;
import track.model.Account;

import java.math.BigInteger;
import java.util.List;

@Transactional
public interface TrackAccountRepository extends JpaRepository<Account, Long> {
	@Query(value = "select * from account c where is_super_user=true and past_date is not null", nativeQuery = true)
	List<Account> findAllParent();

	@Query(value = "select * from account c where parent = ?1", nativeQuery = true)
	List<Account> findByParent(Long account);

	@Query(value = "select count(*) from account where parent = ?1 and pub_date > ?2 and pub_date < ?3", nativeQuery = true)
	BigInteger countByRootParent(Long accountId, String startDate, String endDate);

}
