package track.service;

import common.model.*;

import java.util.List;
import java.util.Map;

/**
 * Created by mxq on 2017/12/27.
 */
public interface TrackAccountService {
    List<TrackAccount4Web> findAll(User user);

    TrackAccount4Web findOne(String email);

    //到期提醒关闭
    Reminder forbiden(User user, Reminder resource);

    //到期提醒开启
    Reminder enable(User user, Reminder resource);

    //催款提醒关闭
    PressMoney forbidenPress(User user, PressMoney resource);

    //催款提醒开启
    PressMoney enablePress(User user, PressMoney resource);


    //缴费
    Payment pay(User user, Payment resource);

    //回访
    BackVisit visit(User user, BackVisit resource);

    //查询功能使用情况
    Map<String, Integer> findFunTimes(Long account, String startDate, String endDate);

    List<Reminder> findRed(Long account, String startDate, String endDate);

    List<BackVisit> findVisit(Long account, String startDate, String endDate);


    List<ContractMoney> findPay(String email, String startDate, String endDate);

    List<Contract> findContract(String email);

    List<ContractChange> findContractChange(String email, String startDate, String endDate);
}
