package track.task;


import common.model.Account4Web;
import common.model.TrackAccount4Web;
import common.repository.TrackAccount4WebRepository;
import org.jsoup.helper.DataUtil;
import org.springframework.beans.factory.annotation.Autowired;
import track.model.Account;
import track.repository.TrackAccountRepository;
import track.service.TrackAccountFlowRestrictService;
import util.DateUtil;
import util.ValidateUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mxq on 2017/12/25.
 */
public class AccountTask {

    @Autowired
    TrackAccountRepository trackAccountRepository;
    @Autowired
    TrackAccount4WebRepository trackAccount4WebRepository;
    @Autowired
    TrackAccountFlowRestrictService trackAccountFlowRestrictService;

    public void task(){
        trackAccount4WebRepository.deleteAll();
        List<TrackAccount4Web> list = new ArrayList<>();
        List<Account> accountList = trackAccountRepository.findAllParent();
        String today = DateUtil.getBeforeDays(0);
        if(ValidateUtil.isValid(accountList)){
            for(Account ac : accountList){
                TrackAccount4Web account4Web = new TrackAccount4Web();
                    account4Web.setAccountId(ac.getId());
                    account4Web.setEmail(ac.getEmail());
                    account4Web.setCompany(ac.getCompany());
                    account4Web.setCreateDate(ac.getPubDate());
                    if(today.compareTo(ac.getPastDate()) > 0){
                        account4Web.setStatus("已过期");
                    }else{
                        account4Web.setStatus("已激活");
                    }
                    account4Web.setTrack(trackAccountFlowRestrictService.findRestrictByAccount(ac));
                    account4Web.setPastDate(ac.getPastDate());
                    account4Web.setUser(ac.getName());
                    account4Web.setTell(ac.getPhone());
                    list.add(account4Web);
            }
        }
        if(ValidateUtil.isValid(list)){
            trackAccount4WebRepository.save(list);
        }
    }
}
