package userio.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import userio.model.App;

import java.math.BigInteger;
import java.util.List;

public interface IOAppRepository extends JpaRepository<App, Long>
{


	@Query(value = "select * from app where account in (select id from account where parent = ?1 or id = ?1) and del_flag is not true", nativeQuery = true)
	List<App> listAppByRootAccount(Long account);

	@Query(value = "select count(*) from app where account  in ?1 and create_time >= ?2 and create_time <= ?3", nativeQuery = true)
	BigInteger countByAccount(List<Long> accountId, String startDate, String endDate);

	@Query(value = "select appkey from app where account  in ?1", nativeQuery = true)
	List<String> findAppkeys(List<Long> accountId);

}
