package userio.task;


import common.model.IOAccount4Web;
import common.repository.IOAccount4WebRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import userio.model.Account;
import userio.model.PackageType;
import userio.model.SalesManLeader;
import userio.repository.IOAccountRepository;
import userio.repository.IOPackageTypeRepository;
import userio.repository.IOSalesManLeaderRepository;
import util.DateUtil;
import util.ValidateUtil;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by mxq on 2017/12/25.
 */
public class IOAccountTask {
    private static Logger logger = LoggerFactory.getLogger(IOAccountTask.class);

    @Autowired
    IOAccountRepository accountRepository;

    @Autowired
    IOAccount4WebRepository account4WebRepository;

    @Autowired
    private IOPackageTypeRepository packageTypeRepository;

    @Autowired
    IOSalesManLeaderRepository salesManLeaderRepository;

    public void task(){
        logger.info("tkio task start :" + System.currentTimeMillis());


        //清空前一天数据
        account4WebRepository.deleteAll();
        List<IOAccount4Web> list = new ArrayList<>();

        //已过期的直接设置成过期
        List<Account> pastAccountList = accountRepository.findRootParentsPast(DateUtil.getBeforeDays(0));
        list.addAll(transform(pastAccountList, "已过期"));

        //未过期
        List<Account> unpastAccountList = accountRepository.findRootParentsUnPast(DateUtil.getBeforeDays(0));
        list.addAll(transform(unpastAccountList, "已激活"));

        List<Account> forbidenList = accountRepository.findRootParentsForidin();
        list.addAll(transform(forbidenList, "已禁用"));

        account4WebRepository.save(list);
        logger.info("tkio task end :" + System.currentTimeMillis());
    }

    List<IOAccount4Web> transform(List<Account> accounts, String status){
        List<SalesManLeader> SalesManLeader = salesManLeaderRepository.findAll();
        Map<Long, String> saleMap = new HashMap<>();
        for(SalesManLeader pt : SalesManLeader){
            saleMap.put((long)pt.getId(), pt.getEmail());
        }
        List<PackageType> packageTypeList = packageTypeRepository.findAll();
        Map<Long, String> map = new HashMap<>();
        for(PackageType pt : packageTypeList){
            map.put(pt.getId(), pt.getPackageName());
        }

        List<IOAccount4Web> list = new ArrayList<>();
        if(ValidateUtil.isValid(accounts)){
            for(Account ac : accounts){
                IOAccount4Web account4Web = new IOAccount4Web();
                account4Web.setStatus(status);

                account4Web.setAccountId(ac.getId());
                account4Web.setEmail(ac.getEmail());
                account4Web.setCompany(ac.getCompany());
                account4Web.setCreateDate(ac.getPubDate());
                account4Web.setPackageType(map.get(ac.getPricelevel()));
                account4Web.setPastDate(ac.getPastDate());
                account4Web.setUser(ac.getName());
                account4Web.setTell(ac.getPhone());
                account4Web.setBussinessMan(ac.getBussinessman());
                if(saleMap.containsKey(ac.getBussinessman())){
                    account4Web.setSaleEamil(saleMap.get(ac.getBussinessman()));
                }
                list.add(account4Web);
            }
        }
        return list;
    }
}
