/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.analysis;

import com.dianping.cat.Cat;
import com.dianping.cat.analysis.MessageAnalyzer;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.message.spi.MessageQueue;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.report.ReportManager;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageAnalyzer<R>
extends ContainerHolder
implements MessageAnalyzer {
    public static final long MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    @Inject
    protected ServerConfigManager m_serverConfigManager;
    private long m_extraTime;
    protected long m_startTime;
    protected long m_duration;
    protected Logger m_logger;
    private long m_errors = 0L;
    private volatile boolean m_active = true;
    protected int m_index;

    @Override
    public void analyze(MessageQueue queue) {
        MessageTree tree;
        while (!this.isTimeout() && this.isActive()) {
            tree = queue.poll();
            if (tree == null) continue;
            try {
                this.process(tree);
            }
            catch (Throwable e) {
                ++this.m_errors;
                if (this.m_errors != 1L && this.m_errors % 10000L != 0L) continue;
                Cat.logError((Throwable)e);
            }
        }
        while ((tree = queue.poll()) != null) {
            try {
                this.process(tree);
            }
            catch (Throwable e) {
                ++this.m_errors;
                if (this.m_errors != 1L && this.m_errors % 10000L != 0L) continue;
                Cat.logError((Throwable)e);
            }
        }
    }

    @Override
    public void destroy() {
        super.release((Object)this);
        ReportManager manager = this.getReportManager();
        if (manager != null) {
            manager.destory();
        }
    }

    @Override
    public abstract void doCheckpoint(boolean var1);

    @Override
    public int getAnanlyzerCount() {
        return 1;
    }

    protected long getExtraTime() {
        return this.m_extraTime;
    }

    public abstract R getReport(String var1);

    @Override
    public long getStartTime() {
        return this.m_startTime;
    }

    @Override
    public void initialize(long startTime, long duration, long extraTime) {
        this.m_extraTime = extraTime;
        this.m_startTime = startTime;
        this.m_duration = duration;
        this.loadReports();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isActive() {
        AbstractMessageAnalyzer abstractMessageAnalyzer = this;
        synchronized (abstractMessageAnalyzer) {
            return this.m_active;
        }
    }

    protected boolean isLocalMode() {
        return this.m_serverConfigManager.isLocalMode();
    }

    protected boolean isTimeout() {
        long endTime;
        long currentTime = System.currentTimeMillis();
        return currentTime > (endTime = this.m_startTime + this.m_duration + this.m_extraTime);
    }

    protected abstract void loadReports();

    protected abstract void process(MessageTree var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        AbstractMessageAnalyzer abstractMessageAnalyzer = this;
        synchronized (abstractMessageAnalyzer) {
            this.m_active = false;
        }
    }

    @Override
    public void setIndex(int index) {
        this.m_index = index;
    }
}

