/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.analysis;

import com.dianping.cat.Cat;
import com.dianping.cat.analysis.MessageAnalyzer;
import com.dianping.cat.analysis.MessageAnalyzerManager;
import com.dianping.cat.analysis.PeriodTask;
import com.dianping.cat.message.io.DefaultMessageQueue;
import com.dianping.cat.message.spi.MessageQueue;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.statistic.ServerStatisticManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Period {
    private long m_startTime;
    private long m_endTime;
    private Map<String, List<PeriodTask>> m_tasks;
    @Inject
    private MessageAnalyzerManager m_analyzerManager;
    @Inject
    private ServerStatisticManager m_serverStateManager;
    @Inject
    private Logger m_logger;
    private static int QUEUE_SIZE = 30000;

    public Period(long startTime, long endTime, MessageAnalyzerManager analyzerManager, ServerStatisticManager serverStateManager, Logger logger) {
        this.m_startTime = startTime;
        this.m_endTime = endTime;
        this.m_analyzerManager = analyzerManager;
        this.m_serverStateManager = serverStateManager;
        this.m_logger = logger;
        List<String> names = this.m_analyzerManager.getAnalyzerNames();
        this.m_tasks = new HashMap<String, List<PeriodTask>>();
        for (String name : names) {
            List<MessageAnalyzer> messageAnalyzers = this.m_analyzerManager.getAnalyzer(name, startTime);
            for (MessageAnalyzer analyzer : messageAnalyzers) {
                DefaultMessageQueue queue = new DefaultMessageQueue(QUEUE_SIZE);
                PeriodTask task = new PeriodTask(analyzer, (MessageQueue)queue, startTime);
                task.enableLogging(this.m_logger);
                List<PeriodTask> analyzerTasks = this.m_tasks.get(name);
                if (analyzerTasks == null) {
                    analyzerTasks = new ArrayList<PeriodTask>();
                    this.m_tasks.put(name, analyzerTasks);
                }
                analyzerTasks.add(task);
            }
        }
    }

    public void distribute(MessageTree tree) {
        this.m_serverStateManager.addMessageTotal(tree.getDomain(), 1L);
        boolean success = true;
        String domain = tree.getDomain();
        for (Map.Entry<String, List<PeriodTask>> entry : this.m_tasks.entrySet()) {
            PeriodTask task;
            boolean enqueue;
            boolean manyTasks;
            List<PeriodTask> tasks = entry.getValue();
            int length = tasks.size();
            int index = 0;
            boolean bl = manyTasks = length > 1;
            if (manyTasks) {
                index = Math.abs(domain.hashCode()) % length;
            }
            if (enqueue = (task = tasks.get(index)).enqueue(tree)) continue;
            if (manyTasks) {
                task = tasks.get((index + 1) % length);
                enqueue = task.enqueue(tree);
                if (enqueue) continue;
                success = false;
                continue;
            }
            success = false;
        }
        if (!success) {
            this.m_serverStateManager.addMessageTotalLoss(tree.getDomain(), 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDate = new Date(this.m_startTime);
        Date endDate = new Date(this.m_endTime - 1L);
        this.m_logger.info(String.format("Finishing %s tasks in period [%s, %s]", this.m_tasks.size(), df.format(startDate), df.format(endDate)));
        try {
            for (Map.Entry<String, List<PeriodTask>> tasks : this.m_tasks.entrySet()) {
                for (PeriodTask task : tasks.getValue()) {
                    task.finish();
                }
            }
        }
        catch (Throwable e) {
            try {
                Cat.logError((Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_logger.info(String.format("Finished %s tasks in period [%s, %s]", this.m_tasks.size(), df.format(startDate), df.format(endDate)));
                throw throwable;
            }
            this.m_logger.info(String.format("Finished %s tasks in period [%s, %s]", this.m_tasks.size(), df.format(startDate), df.format(endDate)));
        }
        this.m_logger.info(String.format("Finished %s tasks in period [%s, %s]", this.m_tasks.size(), df.format(startDate), df.format(endDate)));
    }

    public List<MessageAnalyzer> getAnalyzer(String name) {
        ArrayList<MessageAnalyzer> analyzers = new ArrayList<MessageAnalyzer>();
        List<PeriodTask> tasks = this.m_tasks.get(name);
        if (tasks != null) {
            for (PeriodTask task : tasks) {
                analyzers.add(task.getAnalyzer());
            }
        }
        return analyzers;
    }

    public List<MessageAnalyzer> getAnalzyers() {
        ArrayList<MessageAnalyzer> analyzers = new ArrayList<MessageAnalyzer>(this.m_tasks.size());
        for (Map.Entry<String, List<PeriodTask>> tasks : this.m_tasks.entrySet()) {
            for (PeriodTask task : tasks.getValue()) {
                analyzers.add(task.getAnalyzer());
            }
        }
        return analyzers;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public boolean isIn(long timestamp) {
        return timestamp >= this.m_startTime && timestamp < this.m_endTime;
    }

    public void start() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.m_logger.info(String.format("Starting %s tasks in period [%s, %s]", this.m_tasks.size(), df.format(new Date(this.m_startTime)), df.format(new Date(this.m_endTime - 1L))));
        for (Map.Entry<String, List<PeriodTask>> tasks : this.m_tasks.entrySet()) {
            List<PeriodTask> taskList = tasks.getValue();
            for (int i = 0; i < taskList.size(); ++i) {
                PeriodTask task = taskList.get(i);
                task.setIndex(i);
                Threads.forGroup((String)"Cat-RealtimeConsumer").start((Runnable)((Object)task));
            }
        }
    }
}

