/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.analysis;

import com.dianping.cat.Cat;
import com.dianping.cat.analysis.MessageAnalyzerManager;
import com.dianping.cat.analysis.Period;
import com.dianping.cat.analysis.PeriodStrategy;
import com.dianping.cat.statistic.ServerStatisticManager;
import java.util.ArrayList;
import java.util.List;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.logging.Logger;

public class PeriodManager
implements Threads.Task {
    private PeriodStrategy m_strategy;
    private List<Period> m_periods = new ArrayList<Period>();
    private boolean m_active;
    @Inject
    private MessageAnalyzerManager m_analyzerManager;
    @Inject
    private ServerStatisticManager m_serverStateManager;
    @Inject
    private Logger m_logger;
    public static long EXTRATIME = 180000L;

    public PeriodManager(long duration, MessageAnalyzerManager analyzerManager, ServerStatisticManager serverStateManager, Logger logger) {
        this.m_strategy = new PeriodStrategy(duration, EXTRATIME, EXTRATIME);
        this.m_active = true;
        this.m_analyzerManager = analyzerManager;
        this.m_serverStateManager = serverStateManager;
        this.m_logger = logger;
    }

    private void endPeriod(long startTime) {
        int len = this.m_periods.size();
        for (int i = 0; i < len; ++i) {
            Period period = this.m_periods.get(i);
            if (!period.isIn(startTime)) continue;
            period.finish();
            this.m_periods.remove(i);
            break;
        }
    }

    public Period findPeriod(long timestamp) {
        for (Period period : this.m_periods) {
            if (!period.isIn(timestamp)) continue;
            return period;
        }
        return null;
    }

    public String getName() {
        return "RealtimeConsumer-PeriodManager";
    }

    public void init() {
        long startTime = this.m_strategy.next(System.currentTimeMillis());
        this.startPeriod(startTime);
    }

    public void run() {
        while (this.m_active) {
            try {
                long now = System.currentTimeMillis();
                long value = this.m_strategy.next(now);
                if (value > 0L) {
                    this.startPeriod(value);
                } else if (value < 0L) {
                    Threads.forGroup((String)"cat").start((Runnable)((Object)new EndTaskThread(-value)));
                }
            }
            catch (Throwable e) {
                Cat.logError((Throwable)e);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void shutdown() {
        this.m_active = false;
    }

    private void startPeriod(long startTime) {
        long endTime = startTime + this.m_strategy.getDuration();
        Period period = new Period(startTime, endTime, this.m_analyzerManager, this.m_serverStateManager, this.m_logger);
        this.m_periods.add(period);
        period.start();
    }

    private class EndTaskThread
    implements Threads.Task {
        private long m_startTime;

        public EndTaskThread(long startTime) {
            this.m_startTime = startTime;
        }

        public String getName() {
            return "End-Consumer-Task";
        }

        public void run() {
            PeriodManager.this.endPeriod(this.m_startTime);
        }

        public void shutdown() {
        }
    }
}

