/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.config.app;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.configuration.app.comparison.entity.AppComparison;
import com.dianping.cat.configuration.app.comparison.entity.AppComparisonConfig;
import com.dianping.cat.configuration.app.comparison.transform.DefaultSaxParser;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.helper.Splitters;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppComparisonConfigManager
implements Initializable {
    @Inject
    private ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    private volatile AppComparisonConfig m_config;
    private static final String CONFIG_NAME = "appComparisonConfig";
    private int m_configId;

    public AppComparisonConfig getConfig() {
        return this.m_config;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_config = DefaultSaxParser.parse(content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse(content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    public boolean insert(String xml) {
        try {
            this.m_config = DefaultSaxParser.parse(xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public Map<String, AppComparison> queryAppComparisons() {
        return this.m_config.getAppComparisons();
    }

    public List<String> queryEmails(String id) {
        ArrayList<String> emails = new ArrayList<String>();
        AppComparison appComparison = this.m_config.getAppComparisons().get(id);
        if (appComparison != null) {
            emails.addAll(Splitters.by((String)",").noEmptyItem().split(appComparison.getEmails()));
        }
        return emails;
    }

    public String queryEmailStr(String id) {
        AppComparison appComparison = this.m_config.getAppComparisons().get(id);
        if (appComparison != null) {
            return appComparison.getEmails();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        AppComparisonConfigManager appComparisonConfigManager = this;
        synchronized (appComparisonConfigManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.m_config.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }
}

