/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.config.server;

import com.dianping.cat.config.server.ServerConfigValidator;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.configuration.server.entity.ConsoleConfig;
import com.dianping.cat.configuration.server.entity.Domain;
import com.dianping.cat.configuration.server.entity.HdfsConfig;
import com.dianping.cat.configuration.server.entity.LongConfig;
import com.dianping.cat.configuration.server.entity.Property;
import com.dianping.cat.configuration.server.entity.ServerConfig;
import com.dianping.cat.configuration.server.entity.StorageConfig;
import com.dianping.cat.configuration.server.transform.DefaultSaxParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.unidal.helper.Files;
import org.unidal.helper.Splitters;
import org.unidal.lookup.logging.LogEnabled;
import org.unidal.lookup.logging.Logger;
import org.unidal.lookup.util.StringUtils;
import org.unidal.tuple.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConfigManager
implements LogEnabled {
    private static final long DEFAULT_HDFS_FILE_MAX_SIZE = 0x8000000L;
    private volatile ServerConfig m_config;
    private Logger m_logger;
    public static final String DUMP_DIR = "dump";

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public String getConsoleDefaultDomain() {
        if (this.m_config != null) {
            return this.m_config.getConsole().getDefaultDomain().toLowerCase();
        }
        return "cat";
    }

    public List<Pair<String, Integer>> getConsoleEndpoints() {
        if (this.m_config != null) {
            ConsoleConfig console = this.m_config.getConsole();
            String remoteServers = console.getRemoteServers();
            List endpoints = Splitters.by((char)',').noEmptyItem().trim().split(remoteServers);
            ArrayList<Pair<String, Integer>> pairs = new ArrayList<Pair<String, Integer>>(endpoints.size());
            for (String endpoint : endpoints) {
                int pos = endpoint.indexOf(58);
                String host = pos > 0 ? endpoint.substring(0, pos) : endpoint;
                int port = pos > 0 ? Integer.parseInt(endpoint.substring(pos + 1)) : 2281;
                pairs.add((Pair<String, Integer>)new Pair((Object)host, (Object)port));
            }
            return pairs;
        }
        return Collections.emptyList();
    }

    public String getConsoleRemoteServers() {
        ConsoleConfig console;
        String remoteServers;
        if (this.m_config != null && (remoteServers = (console = this.m_config.getConsole()).getRemoteServers()) != null && remoteServers.length() > 0) {
            return remoteServers;
        }
        return "127.0.0.1:2281";
    }

    public String getHdfsBaseDir(String id) {
        String baseDir;
        HdfsConfig hdfsConfig;
        if (this.m_config != null && (hdfsConfig = this.m_config.getStorage().findHdfs(id)) != null && (baseDir = hdfsConfig.getBaseDir()) != null && baseDir.trim().length() > 0) {
            return baseDir;
        }
        return null;
    }

    public long getHdfsFileMaxSize(String id) {
        if (this.m_config != null) {
            StorageConfig storage = this.m_config.getStorage();
            HdfsConfig hdfsConfig = storage.findHdfs(id);
            return this.toLong(hdfsConfig == null ? null : hdfsConfig.getMaxSize(), 0x8000000L);
        }
        return 0x8000000L;
    }

    public String getHdfsLocalBaseDir(String id) {
        if (this.m_config != null) {
            StorageConfig storage = this.m_config.getStorage();
            return new File(storage.getLocalBaseDir(), id).getPath();
        }
        if (id == null) {
            return "target/bucket";
        }
        return "target/bucket/" + id;
    }

    public int getHdfsMaxStorageTime() {
        if (this.m_config != null) {
            StorageConfig storage = this.m_config.getStorage();
            return storage.getMaxHdfsStorageTime();
        }
        return 15;
    }

    public Map<String, String> getHdfsProperties() {
        if (this.m_config != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (Property p : this.m_config.getStorage().getProperties().values()) {
                properties.put(p.getName(), p.getValue());
            }
            return properties;
        }
        return Collections.emptyMap();
    }

    public String getHdfsServerUri(String id) {
        String serverUri;
        HdfsConfig hdfsConfig;
        if (this.m_config != null && (hdfsConfig = this.m_config.getStorage().findHdfs(id)) != null && (serverUri = hdfsConfig.getServerUri()) != null && serverUri.trim().length() > 0) {
            return serverUri;
        }
        return null;
    }

    public int getLocalReportStroageTime() {
        if (this.m_config != null) {
            StorageConfig storage = this.m_config.getStorage();
            return storage.getLocalReportStorageTime();
        }
        return 7;
    }

    public int getLogViewStroageTime() {
        if (this.m_config != null) {
            StorageConfig storage = this.m_config.getStorage();
            return storage.getLocalLogivewStorageTime();
        }
        return 30;
    }

    public int getHdfsUploadThreadCount() {
        if (this.m_config != null) {
            StorageConfig storage = this.m_config.getStorage();
            return storage.getUploadThread();
        }
        return 5;
    }

    public Map<String, Domain> getLongConfigDomains() {
        LongConfig longConfig;
        if (this.m_config != null && (longConfig = this.m_config.getConsumer().getLongConfig()) != null) {
            return longConfig.getDomains();
        }
        return Collections.emptyMap();
    }

    public int getLongUrlDefaultThreshold() {
        LongConfig longConfig;
        if (this.m_config != null && (longConfig = this.m_config.getConsumer().getLongConfig()) != null && longConfig.getDefaultSqlThreshold() != null) {
            return longConfig.getDefaultSqlThreshold();
        }
        return 1000;
    }

    public ServerConfig getServerConfig() {
        return this.m_config;
    }

    public void initialize(File configFile) throws Exception {
        if (configFile != null && configFile.canRead()) {
            this.m_logger.info(String.format("Loading configuration file(%s) ...", configFile.getCanonicalPath()));
            String xml = Files.forIO().readFrom(configFile, "utf-8");
            ServerConfig config = DefaultSaxParser.parse(xml);
            config.accept(new ServerConfigValidator());
            this.m_config = config;
        } else {
            if (configFile != null) {
                this.m_logger.warn(String.format("Configuration file(%s) not found, IGNORED.", configFile.getCanonicalPath()));
            }
            ServerConfig config = new ServerConfig();
            config.accept(new ServerConfigValidator());
            this.m_config = config;
        }
        if (this.m_config.isLocalMode()) {
            this.m_logger.warn("CAT server is running in LOCAL mode! No HDFS or MySQL will be accessed!");
        }
        this.m_logger.info("CAT server is running with hdfs," + this.isHdfsOn());
        this.m_logger.info("CAT server is running with alert," + this.isAlertMachine());
        this.m_logger.info("CAT server is running with job," + this.isJobMachine());
        this.m_logger.info(this.m_config.toString());
    }

    public boolean isAlertMachine() {
        if (this.m_config != null) {
            boolean alert = this.m_config.isAlertMachine();
            String ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
            return "10.1.6.128".equals(ip) || alert;
        }
        return false;
    }

    public boolean isCacheTransaction(String type) {
        return StringUtils.isNotEmpty((String)type) && type.startsWith("Cache.memcached");
    }

    public boolean isHdfsOn() {
        if (this.m_config != null) {
            return this.m_config.getHdfsMachine();
        }
        return false;
    }

    public boolean isJobMachine() {
        if (this.m_config != null) {
            return this.m_config.isJobMachine();
        }
        return true;
    }

    public boolean isLocalMode() {
        if (this.m_config != null) {
            return this.m_config.isLocalMode();
        }
        return true;
    }

    public boolean isRpcClient(String type) {
        return "PigeonCall".equals(type) || "Call".equals(type);
    }

    public boolean isRpcServer(String type) {
        return "PigeonService".equals(type) || "Service".equals(type);
    }

    public boolean isSendMachine() {
        if (this.m_config != null) {
            return this.m_config.isSendMachine();
        }
        return false;
    }

    public boolean isSQLTransaction(String type) {
        return "SQL".equals(type);
    }

    private long toLong(String str, long defaultValue) {
        long value = 0L;
        int len = str == null ? 0 : str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (Character.isDigit(ch)) {
                value = value * 10L + (long)(ch - 48);
                continue;
            }
            if (ch == 'm' || ch == 'M') {
                value *= 0x100000L;
                continue;
            }
            if (ch != 'k' && ch != 'K') continue;
            value *= 1024L;
        }
        if (value > 0L) {
            return value;
        }
        return defaultValue;
    }

    public boolean validateIp(String str) {
        Pattern pattern = Pattern.compile("^((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]|[*])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]|[*])$");
        return pattern.matcher(str).matches();
    }
}

