/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.app.transform;

import com.dianping.cat.configuration.app.IEntity;
import com.dianping.cat.configuration.app.entity.AppConfig;
import com.dianping.cat.configuration.app.entity.Code;
import com.dianping.cat.configuration.app.entity.Command;
import com.dianping.cat.configuration.app.entity.ConfigItem;
import com.dianping.cat.configuration.app.entity.Item;
import com.dianping.cat.configuration.app.transform.DefaultLinker;
import com.dianping.cat.configuration.app.transform.DefaultSaxMaker;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static AppConfig parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(AppConfig.class, new InputSource(DefaultSaxParser.removeBOM(in)));
    }

    public static AppConfig parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(AppConfig.class, new InputSource(DefaultSaxParser.removeBOM(reader)));
    }

    public static AppConfig parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(AppConfig.class, new InputSource(new StringReader(DefaultSaxParser.removeBOM(xml))));
    }

    private static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(type, new InputSource(DefaultSaxParser.removeBOM(in)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(type, new InputSource(new StringReader(DefaultSaxParser.removeBOM(xml))));
    }

    private static <T> T removeBOM(T obj) throws IOException {
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.length() != 0 && str.charAt(0) == '\ufeff') {
                return (T)str.substring(1);
            }
            return obj;
        }
        if (obj instanceof InputStream) {
            BufferedInputStream in = new BufferedInputStream((InputStream)obj);
            in.mark(3);
            if (in.read() != 239 || in.read() != 187 || in.read() != 191) {
                in.reset();
            }
            return (T)in;
        }
        if (obj instanceof Reader) {
            BufferedReader in = new BufferedReader((Reader)obj);
            in.mark(1);
            if (in.read() != 65279) {
                in.reset();
            }
            return (T)in;
        }
        return obj;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            this.m_objs.pop();
            this.m_tags.pop();
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForAppConfig(AppConfig parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("config-item".equals(qName)) {
            ConfigItem configItem = this.m_maker.buildConfigItem(attributes);
            this.m_linker.onConfigItem(parentObj, configItem);
            this.m_objs.push(configItem);
        } else if ("code".equals(qName)) {
            Code code = this.m_maker.buildCode(attributes);
            this.m_linker.onCode(parentObj, code);
            this.m_objs.push(code);
        } else if ("command".equals(qName)) {
            Command command = this.m_maker.buildCommand(attributes);
            this.m_linker.onCommand(parentObj, command);
            this.m_objs.push(command);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under app-config!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForCode(Code parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForCommand(Command parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"code".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under command!", qName));
        }
        Code code = this.m_maker.buildCode(attributes);
        this.m_linker.onCode(parentObj, code);
        this.m_objs.push(code);
        this.m_tags.push(qName);
    }

    private void parseForConfigItem(ConfigItem parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"item".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under config-item!", qName));
        }
        Item item = this.m_maker.buildItem(attributes);
        this.m_linker.onItem(parentObj, item);
        this.m_objs.push(item);
        this.m_tags.push(qName);
    }

    private void parseForItem(Item parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("app-config".equals(qName)) {
            AppConfig appConfig;
            this.m_entity = appConfig = this.m_maker.buildAppConfig(attributes);
            this.m_objs.push(appConfig);
            this.m_tags.push(qName);
        } else if ("config-item".equals(qName)) {
            ConfigItem configItem;
            this.m_entity = configItem = this.m_maker.buildConfigItem(attributes);
            this.m_objs.push(configItem);
            this.m_tags.push(qName);
        } else if ("item".equals(qName)) {
            Item item;
            this.m_entity = item = this.m_maker.buildItem(attributes);
            this.m_objs.push(item);
            this.m_tags.push(qName);
        } else if ("command".equals(qName)) {
            Command command;
            this.m_entity = command = this.m_maker.buildCommand(attributes);
            this.m_objs.push(command);
            this.m_tags.push(qName);
        } else if ("code".equals(qName)) {
            Code code;
            this.m_entity = code = this.m_maker.buildCode(attributes);
            this.m_objs.push(code);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = this.m_tags.peek();
            if (parent instanceof AppConfig) {
                this.parseForAppConfig((AppConfig)parent, tag, qName, attributes);
            } else if (parent instanceof ConfigItem) {
                this.parseForConfigItem((ConfigItem)parent, tag, qName, attributes);
            } else if (parent instanceof Item) {
                this.parseForItem((Item)parent, tag, qName, attributes);
            } else if (parent instanceof Command) {
                this.parseForCommand((Command)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof Code)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForCode((Code)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

