/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.web.url.transform;

import com.dianping.cat.configuration.web.url.BaseEntity;
import com.dianping.cat.configuration.web.url.IEntity;
import com.dianping.cat.configuration.web.url.IVisitor;
import com.dianping.cat.configuration.web.url.entity.Code;
import com.dianping.cat.configuration.web.url.entity.PatternItem;
import com.dianping.cat.configuration.web.url.entity.UrlPattern;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private UrlPattern m_urlPattern;

    public DefaultMerger() {
    }

    public DefaultMerger(UrlPattern urlPattern) {
        this.m_urlPattern = urlPattern;
        this.m_objs.push(urlPattern);
    }

    public UrlPattern getUrlPattern() {
        return this.m_urlPattern;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept(this);
        this.m_objs.pop();
    }

    protected void mergeCode(Code to, Code from) {
        to.mergeAttributes(from);
    }

    protected void mergePatternItem(PatternItem to, PatternItem from) {
        to.mergeAttributes(from);
    }

    protected void mergeUrlPattern(UrlPattern to, UrlPattern from) {
        to.mergeAttributes(from);
    }

    @Override
    public void visitCode(Code from) {
        Code to = (Code)this.m_objs.peek();
        this.mergeCode(to, from);
        this.visitCodeChildren(to, from);
    }

    protected void visitCodeChildren(Code to, Code from) {
    }

    @Override
    public void visitPatternItem(PatternItem from) {
        PatternItem to = (PatternItem)this.m_objs.peek();
        this.mergePatternItem(to, from);
        this.visitPatternItemChildren(to, from);
    }

    protected void visitPatternItemChildren(PatternItem to, PatternItem from) {
    }

    @Override
    public void visitUrlPattern(UrlPattern from) {
        UrlPattern to = (UrlPattern)this.m_objs.peek();
        this.mergeUrlPattern(to, from);
        this.visitUrlPatternChildren(to, from);
    }

    protected void visitUrlPatternChildren(UrlPattern to, UrlPattern from) {
        BaseEntity target;
        for (PatternItem patternItem : from.getPatternItems().values()) {
            target = to.findPatternItem(patternItem.getName());
            if (target == null) {
                target = new PatternItem(patternItem.getName());
                to.addPatternItem((PatternItem)target);
            }
            this.m_objs.push(target);
            patternItem.accept(this);
            this.m_objs.pop();
        }
        for (Code code : from.getCodes().values()) {
            target = to.findCode(code.getId());
            if (target == null) {
                target = new Code(code.getId());
                to.addCode((Code)target);
            }
            this.m_objs.push(target);
            code.accept(this);
            this.m_objs.pop();
        }
    }
}

