/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.storage;

import com.dianping.cat.message.storage.MessageBlock;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class MessageBlockWriter {
    private RandomAccessFile m_indexFile;
    private RandomAccessFile m_dataFile;
    private int m_blockAddress;

    public MessageBlockWriter(File dataFile) throws IOException {
        File indexFile = new File(dataFile.getAbsolutePath() + ".idx");
        dataFile.getParentFile().mkdirs();
        this.m_indexFile = new RandomAccessFile(indexFile, "rw");
        this.m_dataFile = new RandomAccessFile(dataFile, "rw");
        this.m_blockAddress = (int)this.m_dataFile.length();
        this.m_dataFile.seek(this.m_blockAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this.m_indexFile;
        synchronized (randomAccessFile) {
            this.m_indexFile.close();
            this.m_dataFile.close();
        }
    }

    public synchronized void writeBlock(MessageBlock block) throws IOException {
        int len = block.getBlockSize();
        byte[] data = block.getData();
        int blockSize = 0;
        for (int i = 0; i < len; ++i) {
            int seq = block.getIndex(i);
            int size = block.getSize(i);
            this.m_indexFile.seek((long)seq * 6L);
            this.m_indexFile.writeInt(this.m_blockAddress);
            this.m_indexFile.writeShort(blockSize);
            blockSize += size;
        }
        this.m_dataFile.writeInt(data.length);
        this.m_dataFile.write(data);
        this.m_blockAddress += data.length + 4;
    }
}

