/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentDao;
import com.dianping.cat.core.dal.HourlyReportDao;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.DomainValidator;
import com.dianping.cat.report.ReportBucket;
import com.dianping.cat.report.ReportBucketManager;
import com.dianping.cat.report.ReportDelegate;
import com.dianping.cat.report.ReportManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.logging.LogEnabled;
import org.unidal.lookup.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReportManager<T>
extends ContainerHolder
implements ReportManager<T>,
Initializable,
LogEnabled {
    @Inject
    private ReportDelegate<T> m_reportDelegate;
    @Inject
    private ReportBucketManager m_bucketManager;
    @Inject
    private HourlyReportDao m_reportDao;
    @Inject
    private HourlyReportContentDao m_reportContentDao;
    @Inject
    private DomainValidator m_validator;
    private String m_name;
    private Map<Long, Map<String, T>> m_reports = new ConcurrentHashMap<Long, Map<String, T>>();
    private Logger m_logger;

    public void cleanup(long time) {
        ArrayList<Long> startTimes = new ArrayList<Long>(this.m_reports.keySet());
        Iterator iterator = startTimes.iterator();
        while (iterator.hasNext()) {
            long startTime = (Long)iterator.next();
            if (startTime > time) continue;
            this.m_reports.remove(startTime);
        }
    }

    @Override
    public void destory() {
        super.release((Object)this);
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public Set<String> getDomains(long startTime) {
        Map<String, T> reports = this.m_reports.get(startTime);
        if (reports == null) {
            return new HashSet<String>();
        }
        Set<String> domains = reports.keySet();
        HashSet<String> result = new HashSet<String>();
        for (String domain : domains) {
            if (!this.m_validator.validate(domain)) continue;
            result.add(domain);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getHourlyReport(long startTime, String domain, boolean createIfNotExist) {
        T report;
        Map<String, T> reports = this.m_reports.get(startTime);
        if (reports == null && createIfNotExist) {
            Map<Long, Map<String, T>> map = this.m_reports;
            synchronized (map) {
                reports = this.m_reports.get(startTime);
                if (reports == null) {
                    reports = new ConcurrentHashMap<String, T>();
                    this.m_reports.put(startTime, reports);
                }
            }
        }
        if (reports == null) {
            reports = new LinkedHashMap<String, T>();
        }
        if ((report = reports.get(domain)) == null && createIfNotExist) {
            Map<String, T> map = reports;
            synchronized (map) {
                report = this.m_reportDelegate.makeReport(domain, startTime, 3600000L);
                reports.put(domain, report);
            }
        }
        if (report == null) {
            report = this.m_reportDelegate.makeReport(domain, startTime, 3600000L);
        }
        return report;
    }

    @Override
    public Map<String, T> getHourlyReports(long startTime) {
        Map<String, T> reports = this.m_reports.get(startTime);
        if (reports == null) {
            return Collections.emptyMap();
        }
        return reports;
    }

    @Override
    public void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, T> loadHourlyReports(long startTime, StoragePolicy policy, int index) {
        Transaction t = Cat.newTransaction((String)"Restore", (String)this.m_name);
        Map<String, T> reports = this.m_reports.get(startTime);
        Cat.logEvent((String)"Restore", (String)(this.m_name + ":" + index));
        ReportBucket bucket = null;
        if (reports == null) {
            reports = new ConcurrentHashMap<String, T>();
            this.m_reports.put(startTime, reports);
        }
        try {
            bucket = this.m_bucketManager.getReportBucket(startTime, this.m_name, index);
            for (String id : bucket.getIds()) {
                String xml = bucket.findById(id);
                T report = this.m_reportDelegate.parseXml(xml);
                reports.put(id, report);
            }
            this.m_reportDelegate.afterLoad(reports);
            t.setStatus("0");
        }
        catch (Throwable e) {
            t.setStatus(e);
            Cat.logError((Throwable)e);
            this.m_logger.error(String.format("Error when loading %s reports of %s!", this.m_name, new Date(startTime)), e);
        }
        finally {
            t.complete();
            if (bucket != null) {
                this.m_bucketManager.closeBucket(bucket);
            }
        }
        return reports;
    }

    public void setBucketManager(ReportBucketManager bucketManager) {
        this.m_bucketManager = bucketManager;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setReportContentDao(HourlyReportContentDao reportContentDao) {
        this.m_reportContentDao = reportContentDao;
    }

    public void setReportDao(HourlyReportDao reportDao) {
        this.m_reportDao = reportDao;
    }

    public void setReportDelegate(ReportDelegate<T> reportDelegate) {
        this.m_reportDelegate = reportDelegate;
    }

    public void setValidator(DomainValidator validator) {
        this.m_validator = validator;
    }

    private void storeDatabase(long startTime, Map<String, T> reports) {
        Date period = new Date(startTime);
        String ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
        for (T report : reports.values()) {
            try {
                String domain = this.m_reportDelegate.getDomain(report);
                HourlyReport r = this.m_reportDao.createLocal();
                r.setName(this.m_name);
                r.setDomain(domain);
                r.setPeriod(period);
                r.setIp(ip);
                r.setType(1);
                this.m_reportDao.insert(r);
                int id = r.getId();
                byte[] binaryContent = this.m_reportDelegate.buildBinary(report);
                HourlyReportContent content = this.m_reportContentDao.createLocal();
                content.setReportId(id);
                content.setContent(binaryContent);
                this.m_reportContentDao.insert(content);
                this.m_reportDelegate.createHourlyTask(report);
            }
            catch (Throwable e) {
                Cat.getProducer().logError(e);
            }
        }
    }

    private void storeFile(Map<String, T> reports, ReportBucket bucket) {
        for (T report : reports.values()) {
            try {
                String domain = this.m_reportDelegate.getDomain(report);
                String xml = this.m_reportDelegate.buildXml(report);
                bucket.storeById(domain, xml);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeHourlyReports(long startTime, StoragePolicy policy, int index) {
        Transaction t = Cat.newTransaction((String)"Checkpoint", (String)this.m_name);
        Map<String, T> reports = this.m_reports.get(startTime);
        ReportBucket bucket = null;
        try {
            t.addData("reports", (Object)(reports == null ? 0 : reports.size()));
            if (reports != null) {
                HashSet<String> errorDomains = new HashSet<String>();
                for (String domain : reports.keySet()) {
                    if (this.m_validator.validate(domain)) continue;
                    errorDomains.add(domain);
                }
                for (String domain : errorDomains) {
                    reports.remove(domain);
                }
                if (!errorDomains.isEmpty()) {
                    this.m_logger.info("error domain:" + errorDomains);
                }
                this.m_reportDelegate.beforeSave(reports);
                if (policy.forFile()) {
                    bucket = this.m_bucketManager.getReportBucket(startTime, this.m_name, index);
                    try {
                        this.storeFile(reports, bucket);
                    }
                    finally {
                        this.m_bucketManager.closeBucket(bucket);
                    }
                }
                if (policy.forDatabase()) {
                    this.storeDatabase(startTime, reports);
                }
            }
            t.setStatus("0");
        }
        catch (Throwable e) {
            Cat.logError((Throwable)e);
            t.setStatus(e);
            this.m_logger.error(String.format("Error when storing %s reports of %s!", this.m_name, new Date(startTime)), e);
        }
        finally {
            this.cleanup(startTime);
            t.complete();
            if (bucket != null) {
                this.m_bucketManager.closeBucket(bucket);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StoragePolicy {
        FILE,
        FILE_AND_DB;


        public boolean forDatabase() {
            return this == FILE_AND_DB;
        }

        public boolean forFile() {
            return this == FILE_AND_DB || this == FILE;
        }
    }
}

