package com.reyun.controller;

import com.reyun.model.Account;
import com.reyun.model.Event4Web;
import com.reyun.model.VirtualEvent;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.EventService;
import com.reyun.service.VirtualEventService;
import com.reyun.util.ResultModel;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created by nolan on 22/12/2016. description:
 */
@Controller
@RequestMapping("{app}/event")
public class EventController {

    @Autowired
    EventService eventService;
    @Autowired
    private VirtualEventService virtualService;

    @RequestMapping(value = "find/param", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findAll(@PathVariable Long app, @RequestParam String names, @RequestParam(required = false) String params) throws JSONException {
        return ResultModel.OK(eventService.listAllNew(app, names, params));
    }

    @RequestMapping(value = "find/value/one", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findOneValue(@PathVariable Long app, @RequestParam String eventname, @RequestParam String attrname) {
        return ResultModel.OK(eventService.listAllValue(app, eventname, attrname));
    }

    @RequestMapping(value = "find/value/attr", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findOneValueByAttr(@PathVariable Long app, @RequestParam String attrName) {
        return ResultModel.OK(eventService.listAllValueByAttr(app, attrName));
        //return ResultModel.OK(eventService.listAllValueByAttrTop50(app, attrName));
    }

    @RequestMapping(value = "find/value/attrs", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findOneValueByAttrs(@PathVariable Long app, @RequestParam String attrNames) {
        return ResultModel.OK(eventService.listAllValueByAttrs(app, attrNames));
    }

    @RequestMapping(value = "find/value", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findAllValue(@PathVariable Long app) {
        return ResultModel.OK(eventService.listValues(app));
    }

	@RequestMapping(value = "find/allAttr", method = RequestMethod.GET)
	@ResponseBody
	public ResultModel findAllAttr( @PathVariable Long app) {
		return ResultModel.OK(eventService.listAllAttr(app));
	}

    @RequestMapping(value = "find/group/properties", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findGroupAttributes(@PathVariable Long app) {
        return ResultModel.OK(eventService.listAllAttributes(app));}

    @RequestMapping(value = "find/common/properties", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findCommonProperties(@PathVariable Long app) {
        //return ResultModel.OK(eventService.listCommonProperties(app, "event"));
        return ResultModel.OK(eventService.listAllEventAttributesTop50(app, "event"));
    }

    @ResponseBody
    @RequestMapping(value = "find", method = RequestMethod.GET)
    public ResultModel findAllEvent(@PathVariable Long app) {
        return ResultModel.OK(eventService.listAllEvent(app));
    }

    @ResponseBody
    @RequestMapping(value = "find/callback", method = RequestMethod.GET)
    public ResultModel findAllEventToCallback(@PathVariable Long app) {
        return ResultModel.OK(eventService.listAllEventToCallback(app));
    }


    @ResponseBody
    @RequestMapping(value = "findOne", method = RequestMethod.GET)
    public ResultModel findOneEventAttr(@PathVariable Long app, @RequestParam String eventName) {
        //eventService.listAllAttr(app);
        return ResultModel.OK();
    }

    @ResponseBody
    @RequestMapping(value = "find/virtual", method = RequestMethod.GET)
    public ResultModel findAllEvent(@PathVariable Long app, @CurrentAccount Account account) {
        List<Event4Web> event4Webs = eventService.listAllEvent(app);
        List<VirtualEvent> eventList = virtualService.findEventList(app, account);
        Event4Web event4Web = null;
        for (VirtualEvent virtualEvent : eventList) {
            if (virtualEvent.isEnable() || virtualEvent.getType().equals("active")) {
                event4Web = new Event4Web();
                event4Web.setEventNameAlias(virtualEvent.getCh_name());
                event4Web.setEventName(virtualEvent.getName());
                event4Web.setEventNumber(0);
                event4Web.setStatus(true);
                event4Web.setVirtual(true);

                event4Webs.add(event4Web);
            }

        }
        return ResultModel.OK(event4Webs);
    }
}
