package com.reyun.controller;

import com.reyun.model.Account;
import com.reyun.model.IntelligentPath;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.IntelligentPathService;
import com.reyun.util.ResultModel;
import com.reyun.util.ResultStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by sunhao on 17/7/18.
 * desc:智能路径controller
 */
@Controller
@RequestMapping("/intelligentpath")
public class IntelligentPathController {

    private final static String UNDEFINED = "undefined";

    @Autowired
    private IntelligentPathService intelligentPathService;

    @RequestMapping(value = "{appId}/query", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel queryIntelligentPath(HttpServletRequest httpServletRequest, @CurrentAccount Account loginAccount, @PathVariable Long appId) {

        String startDate = httpServletRequest.getParameter("startdate");
        String endDate = httpServletRequest.getParameter("enddate");
        String eventCondition = httpServletRequest.getParameter("eventCondition");
        String events = httpServletRequest.getParameter("events");
        String targetEvent = httpServletRequest.getParameter("targetEvent");
        Boolean startOrEnd = Boolean.valueOf(httpServletRequest.getParameter("startOrEnd"));
        String session = httpServletRequest.getParameter("session");
        String sessionUnit = httpServletRequest.getParameter("sessionUnit");

        String userGroup = httpServletRequest.getParameter("userGroup");

        //参数校验
        if (StringUtils.isEmpty(startDate) || UNDEFINED.equals(startDate)
                || StringUtils.isEmpty(endDate) || UNDEFINED.equals(endDate)
                || StringUtils.isEmpty(eventCondition) || UNDEFINED.equals(eventCondition)
                || StringUtils.isEmpty(events) || UNDEFINED.equals(events)
                || StringUtils.isEmpty(targetEvent) || UNDEFINED.equals(targetEvent)
                || StringUtils.isEmpty(startOrEnd)
                || StringUtils.isEmpty(session) || UNDEFINED.equals(session)
                || StringUtils.isEmpty(sessionUnit) || UNDEFINED.equals(sessionUnit)) {

            return ResultModel.ERROR(ResultStatus.PARAM_INVALID);
        }

        IntelligentPath intelligentPath = new IntelligentPath(appId, events, startOrEnd, targetEvent, Long.parseLong(session), Long.parseLong(sessionUnit), eventCondition, startDate, endDate);

        //用户分群
        if (!StringUtils.isEmpty(userGroup)) {
            intelligentPath.setUserGroup(Long.parseLong(userGroup));
        }

        return ResultModel.OK(intelligentPathService.queryIntelligentPath(loginAccount, intelligentPath));
    }
}
