package com.reyun.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.reyun.service.TipService;
import com.reyun.util.ResultModel;

/**
 * Created by nolan on 22/12/2016.
 * description:
 */
@Controller
@RequestMapping("tip")
public class TipController {

    @Autowired
    private TipService tipService;

    @RequestMapping(value = "{menu}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findByMenu(@PathVariable String menu) {
        return ResultModel.OK(tipService.findAllByMenu(menu));
    }
}
