package com.reyun.log;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Created by nolan on 27/12/2016.
 * description:
 */
@Component
public class OperateLogConsumer implements Runnable {

    private ExecutorService executorService;

    @Autowired
    private OperateLogService operateLogService;

    @PostConstruct
    public void init() {
        int cpuNums = Runtime.getRuntime().availableProcessors();
        executorService = Executors.newFixedThreadPool(cpuNums * 3);
    }

    @PreDestroy
    public void destory() {
        if (executorService != null && !executorService.isShutdown())
            executorService.shutdown();
    }

    @Override
    public void run() {
        executorService.execute(new Runnable() {
            @Override
            public void run() {

            }
        });
    }
}
