package com.reyun.model;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * Created by sunhao on 17/3/1.
 */
@Table(uniqueConstraints = @UniqueConstraint(columnNames={"noticeid","accountid"}))
@Entity
public class UserNoticeLog {

    private Long id;
    @NotNull
    private Long noticeid;
    @NotNull
    private Long accountid;
    @NotNull
    private Date readdate;

    public UserNoticeLog(){super();}

    public UserNoticeLog(Long noticeId, Long accountId,Date readDate)
    {
        this.noticeid = noticeId;
        this.accountid = accountId;
        this.readdate = readDate;
    }

    @Id
    @GeneratedValue
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getReaddate() {
        return readdate;
    }

    public void setReaddate(Date readdate) {
        this.readdate = readdate;
    }

    public Long getNoticeid() {
        return noticeid;
    }

    public void setNoticeid(Long noticeid) {
        this.noticeid = noticeid;
    }

    public Long getAccountid() {
        return accountid;
    }

    public void setAccountid(Long accountid) {
        this.accountid = accountid;
    }
}
