package com.reyun.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import com.reyun.model.Category;

import java.util.List;

@Transactional
public interface CategoryRepository extends JpaRepository<Category, Long> {

    @Query(value = "select * from category c where c.categoryid in ?1", nativeQuery = true)
    List<Category> findByIds(List<Long> ids);

    @Query(value = "select c.categoryname from category c where c.categoryid = ?1", nativeQuery = true)
    String findNameByCategoryId(Long categoryId);
}
