package com.reyun.repository;

import java.math.BigInteger;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import com.reyun.model.CommonParam;
@Transactional
public interface CommonParamRepository extends JpaRepository<CommonParam, Long> {

	@Query(value="select * from common_param where type=?1 order by sort_id ",nativeQuery=true)
	List<CommonParam> findAllByType(String type);

    @Query(value="select * from common_param order by sort_id ",nativeQuery=true)
    List<CommonParam> findAllCommonParam();

	@Query(value = "SELECT * FROM common_param WHERE alias=?1 AND type=?2", nativeQuery = true)
	CommonParam findByAlias(String alias, String type);

	@Query(value = "select count(*) from common_param where type=?1",nativeQuery = true)
	BigInteger findNumByType(String type);
}
