package com.reyun.repository;

import com.reyun.model.DataAuth;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public interface DataAuthRepository extends JpaRepository<DataAuth, Long> {

    @Query(value = "select * from data_auth where account in ?1", nativeQuery = true)
    List<DataAuth> findDataAuthByAccount(List<Long> account);

    @Query(value = "select * from data_auth where account = ?1", nativeQuery = true)
    List<DataAuth> findDataAuthByAccount(Long account);

    @Query(value = "select * from data_auth where account = ?1 and app=?2", nativeQuery = true)
    List<DataAuth> findDataAuthByAccountAndApp(Long account, Long app);

    @Query(value = "select * from data_auth where account = ?2 and app in (select app from auth where create_account in ?1 and account = ?2)", nativeQuery = true)
    List<DataAuth> findDataAuthByCreateAccount(List<Long> createAccount, Long channelAccount);

    @Transactional
    @Modifying
    @Query(value = "delete from data_auth where account = ?1", nativeQuery = true)
    void deleteAuthByAccount(Long account);

    @Query(value = "select * from data_auth where app = ?1 and channel =?2 and campaign =?3", nativeQuery = true)
    List<DataAuth> listDataAuthByAppChnCam(Long app, Long channel, Long campain);

    Iterable<DataAuth> findByApp(Long id);

    @Query(value = "select account from data_auth where app = ?1 and channel =?2 and campaign =?3", nativeQuery = true)
    List<Long> listAccountByAppChnCam(Long app, Long channel, Long campain);

    @Query(value = "select * from data_auth where channel =?1", nativeQuery = true)
    List<DataAuth> listDataAuthByChannel(Long channel);

    @Query(value = "select * from data_auth where account = ?1 and app = ?2 and all_campaign = 1", nativeQuery = true)
    List<DataAuth> listByAllCampaign(Long account, Long app);
}
