package com.reyun.repository;

import java.util.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import com.reyun.model.ExportReportInfo;

@Transactional
public interface ExportReportInfoRepository extends JpaRepository<ExportReportInfo, Long> {

    @Query(value = "select * from export_report_info where app = ?1 and create_time > ?2  order by create_time desc ", nativeQuery = true)
    List<ExportReportInfo> findByApp(Long app, Date startDate);

    @Query(value = "select * from export_report_info where app = ?1 and create_time > ?2 and account = ?3  order by create_time desc ", nativeQuery = true)
    List<ExportReportInfo> findByAccountAndApp(Long app, Date startDate, Long accountId);


    @Query(value = "select * from export_report_info where app = ?1 and file_name = ?2", nativeQuery = true)
	ExportReportInfo findByAppAndFileName(Long app, String fileName);
	
	@Transactional
	@Modifying
	@Query(value="update ExportReportInfo set status = ?2, modifyTime=?3, modifyAccount=?4 where id = ?1")
	int updateStatus(Long id, String status, Date date, Long account);
	
	@Transactional
	@Modifying
	@Query(value="update ExportReportInfo set status = ?2, modifyTime=?3 where id = ?1")
	int updateStatus(Long id, String status, Date date);

    @Transactional
    @Modifying
    @Query(value = "update ExportReportInfo set download_account = ?2, download_name = ?3, download_ip = ?4, download_time = ?5 where id = ?1 ")
    int updateDownloadInfo(Long downloadId, Long downloadAccount, String downloadName, String downloadIp, Date downloadTime);


	@Query(value = "select * from export_report_info where status in (?1,?2)", nativeQuery = true)
	List<ExportReportInfo> findByStatus(String code, String code2);

    @Query(value = "select * from export_report_info where status = 'complete' and  create_time < ?1", nativeQuery = true)
    List<ExportReportInfo> listInvalidExport(Date nowDate);

}
