package com.reyun.service.impl;

import com.reyun.model.AppTag;
import com.reyun.repository.AppTagRepository;
import com.reyun.service.IAppTagService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * description:
 *
 * @author nolan
 * @date 26/12/2017
 */
@Service
public class AppTagServiceImpl
        implements IAppTagService{
    @Autowired
    private AppTagRepository appTagRepository;

    @Override
    public List<AppTag> findByApp(Long app) {
        return appTagRepository.findByApp(app);
    }

    @Override
    public void saveOrUpdate(Long app, List<AppTag> appTagList) {
        appTagRepository.deleteByApp(app);
        appTagList.forEach(appTag -> {
            appTag.setApp(app);
        });
        this.appTagRepository.save(appTagList);
    }
}
