package com.reyun.util;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisConnectionException;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;

/**
 * 单节点Jedis.
 *
 * @author Administrator
 */
public class EventRedisUtil
{
    private static Logger logger = LoggerFactory.getLogger(EventRedisUtil.class);

    private JedisPool pool;

    private EventRedisUtil()
    {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("redis");
        pool = new JedisPool(
                new GenericObjectPoolConfig(),
                resourceBundle.getString("redis.event.host"),
                Integer.valueOf(resourceBundle.getString("redis.event.port")),
                Integer.parseInt(Constant.REDIS_IP_REQUEST_TIMES),
                null,
                Integer.valueOf(resourceBundle.getString("redis.event.database")),
                null);
    }

    public static EventRedisUtil getInstance()
    {
        return SingleHolder.instance;
    }

    /**
     * 取值
     *
     * @param key
     * @return
     */
    public Set get(String key)
    {
        Jedis jedis = pool.getResource();
        try {
            Set set = jedis.zrange(key, 0, -1);
            return set;
        }
        finally {
            pool.returnResource(jedis);
        }
    }

    /**
     * 获取zset的值
     */
    public Set<String> getZsetByKeys(List<String> keys) {

        Set<String> resultSet = new HashSet<>();
        Set<String> resultSet50 = new HashSet<>();

        Jedis jedis = null;
        try {
            jedis = pool.getResource();
            Pipeline p = jedis.pipelined();
            List<Response<Set<String>>> list = new ArrayList<>();

            for (String key : keys) {
                Response<Set<String>> response = p.zrange(key, 0, 50);
                list.add(response);
            }

            p.sync();
            pool.returnResource(jedis);

            if (ValidateUtil.isValid(list)) {
                for (Response<Set<String>> res : list) {
                    Set<String> set = res.get();

                    if (!CollectionUtils.isEmpty(set)) {
                        resultSet.addAll(set);
                    }
                }
            }

            int i=0;
            for(String s:resultSet){
                resultSet50.add(s);
                if(i==50)break;
                i++;
            }

        } catch (JedisConnectionException e) {

            logger.error(e.getMessage(), e);

            if (null != jedis) {
                pool.returnBrokenResource(jedis);
            }

            throw new JedisConnectionException(e);
        }

        //return resultSet;
        return resultSet50;
    }

    private static class SingleHolder
    {
        private static EventRedisUtil instance = new EventRedisUtil();
    }

    public static void main(String[] args) {
		System.out.println(getInstance().get("20fae09987bba0e8609eaad64dbd440d,install,_province,string,1"));
	}

}
