(function () {
    'use strict';

    angular.module("app")
    .factory("UtilService",UtilService);

    function UtilService(){
    	var service = {};
    	service.randRange = function(min, max) {
            var randNumber = Math.floor(Math.random() * (max - min + 1)) + min;
            return randNumber;
        };
        service.sortArray = function(array, flag) {
            if (flag == "desc") {
                return array.sort(function(x, y) {
                    return x == y ? 0 : (x > y ? -1 : 1);
                });
            } else {
                return array.sort(function(x, y) {
                    return x == y ? 0 : (x > y ? 1 : -1);
                });
            }
        };
        service.getMaxByArray = function(array){
            var arr = service.cloneJSON(array);
            arr = arr.sort(function(x,y){
                return x == y ? 0 : (x > y ? -1 : 1);
            });
            return arr[0];
        };
        service.sortArray2 = function(array,name,index,flag) {
            var tempArr = [],len = array.length;
            if(len > 0){
                name.filter(function(n,j){
                    var temp = [];
                    for(var i=0;i<len;i++){
                        temp.push(array[i][j]);
                    }
                    temp.push(n);
                    tempArr.push(temp);
                });

                if (flag == "desc") {
                    tempArr.sort(function(x, y) {
                        return x[index] == y[index] ? 0 : (x[index] > y[index] ? -1 : 1);
                    });
                } else {
                    tempArr.sort(function(x, y) {
                        return x[index] == y[index] ? 0 : (x[index] > y[index] ? 1 : -1);
                    });
                }
                tempArr.filter(function(item,j){
                    name[j] = item.pop();
                    for(var i=0;i<len;i++){
                        array[i][j] = item[i];
                    }
                });
            }
        };
        service.sumArray = function(array){
            var sum = 0;
            for(var i=0;i<array.length;i++){
                if(array[i]!=null){
                    sum += array[i];
                }
            }
            return sum;
        };
        service.decimal2 = function(nm, n) {
            n = n ? n : 2;
            var ts = "1";
            var tn = 1;
            for (var i = 0; i < n; i++) {
                ts += "0";
            }
            tn = parseInt(ts);
            var num = Math.round(nm * tn) / tn;
            var numstr = num + "";
            var dotindex = numstr.indexOf(".");
            var newstr = '';
            if (dotindex > 0) {
                newstr = numstr.substring(dotindex, numstr.length);
                if (newstr > 2) {
                    numstr = numstr.substring(0, numstr.length - 2);
                    num = parseFloat(numstr);
                }
            }
            return num;
        };
        /*0今天，-1昨天。。。*/
        service.getDay = function(num){
            var time = new Date(),
                    dayFn = function(date) {
                        var YY = date.getFullYear(),
                            MM = date.getMonth() + 1,
                            DD = date.getDate();
                        if (MM < 10) MM = "0" + MM;
                        if (DD < 10) DD = "0" + DD;
                        return YY + "-" + MM + "-" + DD
                    },
                    times = time.getTime() + (1000 * 60 * 60 * 24 * num);

            time.setTime(times);

            return dayFn(time);
        };

        /**
         * 某一天之前的几个月 返回值格式YYYY-MM-DD
         */
        service.getLastMonthsDate = function (day, num) {
            var resultDate = new Date(day);
            resultDate.setMonth(resultDate.getMonth() - Number(num));
            return resultDate.Format("yyyy-MM-dd");
        };

        //一年多少周
        service.getYearWeekList = function(year){
            if(typeof year == 'undefined'){
                var d = new Date();
                year = d.getFullYear();
            }

            var weeklist = [];
            var firstDay = new Date(year, 0, 1),fw = firstDay.getDay();
            var maxDay = new Date(year, 11, 31);

            fw = fw == 0 ? 7 :fw;
            var endDay = firstDay.clone().addDays(7 - fw),w = 0;
            //当年的第一天为周五周六周日并到上一年
            if(fw > 0 && fw < 5){
                w = 1;
                weeklist.push({
                    week : w,
                    date : endDay,
                    year : year
                });
            }

            while(endDay < maxDay && !maxDay.isSameDay(endDay)){
                w ++ ;
                endDay = endDay.clone().addDays(7);
                weeklist.push({
                    week : w,
                    date : endDay,
                    year : year
                });
            }

            var lastDay = new Date(year, 11, 31),lastW = lastDay.getDay();
            //当年最后一天是周五周六或者周日时，移到下一年
            if(lastW > 0 && lastW < 4){
                weeklist.pop();
            }
            return weeklist;
        }
        service.getYearWeekCount = function(year){
            return service.getYearWeekList(year).length;
        }
        //当前周数
        service.getNowWeekNum = function(){
            var today = Date.today();
            var firstDay = new Date(today.getFullYear(), 0, 1),fw = firstDay.getDay();
            var endDay = firstDay.clone(),n = 0;
            if( fw > 0){
                endDay = endDay.addDays(8-fw);
                n = 1;
            }
            var days = diffDate(endDay , today);
            return Math.ceil(days/7) + n;
        }

        service.cloneJSON = function(para){
            var rePara = null;
            var type = Object.prototype.toString.call(para);
            if(type.indexOf("Object") > -1){
                rePara = jQuery.extend(true, {}, para);
             }else if(type.indexOf("Array") > 0){
                 rePara = para.concat();
             }else{
                rePara = para;
             }
            return rePara;
        };

        service.splitString = function(str, olength){
            var resString = '',
                len = 0,
                reg = new RegExp(/[^\x00-\xff]/);
            for(var i = 0; i < str.length; i++){
                var char = str.charAt(i);
                len += (reg.test(char) ? 2 : 1);
                if(len <= olength){
                    resString += char;
                }
            }
            return {
                str: resString,
                len: len
            };
        };
        //数组合并
        service.merge = function(){
            return Array.prototype.concat.apply([], arguments);
        }

        service.isNullStr = function(str){
            if(angular.isUndefined(str) || str=="" || str == null || str == 'null'){
                return true;
            }else{
                return false;
            }
        }

        service.getStr = function(n){
            if(n < 10){
                return "0"+n;
            }else{
                return n+"";
            }
        }

        service.setCookie = function(n,_value,d){
            $.cookie("io_"+n,_value,{expires:d,path:'/',secure:false,raw:false});
        }
        service.getCookie = function(n){
            return $.cookie("io_"+n);
        }

        service.setItem = function(n,_value){
            window.localStorage.setItem(n,_value);
        }
        service.getItem = function(n){
            return window.localStorage.getItem(n);
        }

        service.copyTxt = function(obj){
            $(obj).select();
            var bol = false;
            try{
                bol = document.execCommand("Copy",'false',null);
            }
            catch(e){
                bol = false;
            }
            return bol;
        }

        service.randRangeId = function() {
            if(service.getCookie('tkRmdId')){
                return service.getCookie('tkRmdId');
            }
            else{
                var randNumber = new Date().getTime() + service.randRange(3,5);
                service.setCookie('tkRmdId',randNumber,3*365);
                return randNumber;
            }
        };
        service.randDeviceId = function() {
            if(localStorage.getItem('rmdDeviceId')){
                return localStorage.getItem('rmdDeviceId');
            }
            else{
                var randNumber = new Date().getTime() + service.randRange(3,10);
                localStorage.setItem('rmdDeviceId',randNumber);
                return randNumber;
            }
        }
        service.setUser = function(user){
           window.localStorage.setItem("io_ry_user",JSON.stringify(user));
        }
        service.getUser = function(){
            var u = localStorage.getItem("io_ry_user");

            if(service.isNullStr(u)){
                return {};
            }
            else{
                return JSON.parse(u);
            }
        }
        service.getTKAppkey = function(){
            return "f0f251af10e66a0c94d2e923d8863105";
        }
        service.getLogRoot = function(){
            return "http://log.reyun.com";
        }
        service.deviceInfo = function(){
            var browser = {
                versions:function(){
                var u = navigator.userAgent, app = navigator.appVersion;
                return {//移动终端浏览器版本信息
                        trident: u.indexOf("Trident") > -1, //IE内核
                        presto: u.indexOf("Presto") > -1, //opera内核
                        webKit: u.indexOf("AppleWebKit") > -1, //苹果、谷歌内核
                        gecko: u.indexOf("Gecko") > -1 && u.indexOf("KHTML") == -1, //火狐内核
                        mobile: !!u.match(/AppleWebKit.*Mobile.*/), //是否为移动终端
                        ios: !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/), //ios终端
                        android: u.indexOf("Android") > -1 || u.indexOf("Linux") > -1, //android终端或者uc浏览器
                        iPhone: u.indexOf("iPhone") > -1 , //是否为iPhone或者QQHD浏览器
                        iPad: u.indexOf("iPad") > -1, //是否iPad
                        webApp: u.indexOf("Safari") == -1 //是否web应该程序，没有头部与底部
                        };
                    }(),
                    language:(navigator.browserLanguage || navigator.language).toLowerCase()
                }

            return browser;
        }
        service.operatorSystem = function(){
            var sUserAgent = navigator.userAgent;
            var isWin = (navigator.platform == "Win32") || (navigator.platform == "Windows");
            var isMac = (navigator.platform == "Mac68K") || (navigator.platform == "MacPPC") || (navigator.platform == "Macintosh") || (navigator.platform == "MacIntel");
            if (isMac)
            {
                return "Mac";
            }

            var bIsIpad = sUserAgent.match(/ipad/i) == "ipad";
            if(bIsIpad){
                return "ipad";
            }
            var isIPhone = (navigator.platform == "iPhone");
            if(isIPhone){
                return "iPhone";
            }

            var isUnix = (navigator.platform == "X11") && !isWin && !isMac;
            if (isUnix){
                return "Unix";
            }

            var isLinux = (String(navigator.platform).indexOf("Linux") > -1);
            var bIsAndroid = sUserAgent.toLowerCase().match(/android/i) == "android";
            if (isLinux) {
                if(bIsAndroid){
                    return "Android";
                }
                else{
                    return "Linux";
                }
            }
            if (isWin) {
                var isWin2K = sUserAgent.indexOf("Windows NT 5.0") > -1 || sUserAgent.indexOf("Windows 2000") > -1;
                if (isWin2K){
                    return "Win2000";
                }

                var isWinXP = sUserAgent.indexOf("Windows NT 5.1") > -1 || sUserAgent.indexOf("Windows XP") > -1;
                if (isWinXP){
                    return "WinXP";
                }

                var isWin2003 = sUserAgent.indexOf("Windows NT 5.2") > -1 || sUserAgent.indexOf("Windows 2003") > -1;
                if (isWin2003){
                    return "Win2003";
                }

                var isWinVista= sUserAgent.indexOf("Windows NT 6.0") > -1 || sUserAgent.indexOf("Windows Vista") > -1;
                if (isWinVista){
                    return "WinVista";
                }

                var isWin7 = sUserAgent.indexOf("Windows NT 6.1") > -1 || sUserAgent.indexOf("Windows 7") > -1;
                if (isWin7){
                    return "Win7";
                }

                var isWin8 = sUserAgent.indexOf("Windows NT 6.2") > -1 || sUserAgent.indexOf("Windows 8") > -1;
                if (isWin8){
                    return "Win8";
                }
            }
            return "other";
        }
        service.getBrowser = function(flag){
            var ua=window.navigator.userAgent,bow = "",vers = "";
              if(ua.toLowerCase().indexOf("micromessenger")>-1){
                  bow = "wechat";
              }
              else if(/Firefox/g.test(ua))
              {
                 ua=ua.split(" ");
                 bow = "Firefox";
                 vers = ua[ua.length-1].split("/")[1];
              }
              else if(/MSIE/g.test(ua))
              {
                  bow="IE";
                  if(ua.indexOf("QQBrowser")>-1){
                      bow = "QQBrowser";
                  }
                  ua = ua.split(";");
                  vers = ua[1].split(" ")[2];
              }
              else if(/Opera/g.test(ua))
              {
                  ua=ua.split(" ");
                  bow = "Opera";
                  vers = ua[ua.length-1].split("/")[1];
              }
              else if(/Chrome/g.test(ua))
              {
                  ua=ua.split(" ");
                  bow = "Chrome";
                  vers = ua[ua.length-2].split("/")[1];
              }
              else if(/^apple\s+/i.test(navigator.vendor))
              {
                  ua=ua.split(" ");
                  bow = "Safair";
                  vers = ua[ua.length-2].split("/")[1];
              }
              else{
                  bow="others";
              }
              var versArr = vers.split(".");
              if(versArr.length>1){
                  vers = versArr[0]+"."+versArr[1];
              }
              if(flag){
                return bow+vers;
              }
              else{
                return bow;
              }

        }
    	return service;
    }
})();
