(function(){
    angular.module("app.collect")
        .controller("retentionCtrl",["$rootScope","$scope","HttpService","ToolService","UtilService","$timeout","$q","$stateParams",retentionCtrl]);

    function retentionCtrl($rootScope,$scope,HttpService,ToolService,UtilService,$timeout,$q,$stateParams){
        var rmd = new Date().getTime();
        var fid = $stateParams.pageid;
        $scope.queryInfoByApp = function(flag,dID){
            if(angular.isUndefined(flag) || flag==5){
                //app下所有事件
                var eventPM = HttpService.getInfo($scope.appid+"/event/find");
                eventPM.then(function(data){
                    $scope.eventListAll = data;
                    $scope.eventList = $scope.eventListAll.filter(function(item){
                        return item.eventName != 'install';
                    });
                });
                //通用属性
                var profilePM = HttpService.getInfo($scope.appid+"/event/find/allAttr");
                $scope.dimenId = "-all";
                profilePM.then(function(data){
                    data.unshift({"dimensionType":"whole",id:"-all",name:"总体",type:"string"});

                    for(var i=0; i< data.length; i++){
                        if(data[i].dimensionType == 'population' || data[i].dimensionType == 'source'){
                            data[i].dimensionType = 'eventlist';
                        }
                    }
                    $scope.dimensionList = data;
                });
            }

            var definePM = HttpService.getInfo("mng/retention/find/"+$scope.appid);
            definePM.then(function(data){
                $scope.seatxt = "";
                $scope.defineList = data;
                $scope.isEditInfo = 1;
                if(flag==2){ //修改自定义事件
                    for(var i=0;i<$scope.defineList.length;i++){
                        if($scope.defineList[i].id == dID){
                            $scope.define = $scope.defineList[i];
                            break;
                        }
                    }
                    $scope.defineFlag = ++rmd;
                }
                if(data.length>0){
                    if(!UtilService.isNullStr(fid)){
                        for(var i=0;i<$scope.defineList.length;i++){
                            if($scope.defineList[i].id == fid){
                                $scope.define = $scope.defineList[i];
                                break;
                            }
                        }
                        $scope.clickDefine($scope.define);
                        fid = null;
                    }
                    else if(flag==1 || (flag == 3 && $scope.define && $scope.define.id == dID)){
                        $scope.clickDefine($scope.defineList[0]);
                    }
                }
                else{
                    $scope.clickType($scope.typeList[1]);
                }

                if(flag == 5){
                    $scope.dimenRmd = ++rmd;
                }
            });
        }

        //选择按设备或者按用户
        /*$scope.deviceList = ToolService.getDeviceTypeList();
        $scope.deviceInit = $scope.deviceList[0].id;
        $scope.$on("deviceId",function(e,msg){
            $scope.seeFlag = msg.info.id;
        });*/
        $scope.deviceId = false;

        $scope.dimensionname = "维度对比";
        $scope.usergroupid = -1;
        $scope.$on("dimensionId",function(e,msg){
            $scope.dimenId = msg.info.id;
            $scope.dimenObj = msg.info;
            $scope.dimenEventType = msg.info.eventType;

            if($scope.dimenId == 'usergroup' && $scope.usergroupid == -1){
                $scope.lengedNames = ["整体"];
                $scope.dimenugkeys = UtilService.cloneJSON(msg.info.key);
                $scope.dimenugkeys.unshift("all");

                msg.info.value.filter(function(item){
                    $scope.lengedNames.push(item);
                });

                $scope.usergroupid = msg.info.key[0];
                $scope.userIndex = 1;
            }
            else{
                $scope.usergroupid = -1;
            }
        });
        $scope.showDemistion = function(){
            return $scope.define && $scope.define.id>0 || $scope.isShowCache;
        }

        //已保存的事件
        $scope.definename = "请选择模板";
        $scope.clickDefine = function(m){
            $scope.define = m;
            $scope.typesign = 'define';
            $scope.typesname = m.name;
            $scope.ename = m.name;
            $scope.defineFlag = ++rmd;
            $scope.showEventWin = false;
            $scope.helpname = "自定义留存";

            $rootScope.thirdtab = m.name;
        }
        $scope.deleteDefine = function(d){
            $scope.delDefine = d;
            ToolService.showAlp();
            ToolService.showLoading();
            var validPM = HttpService.getInfo("custommenu/delete/valid/"+d.id+"?type=retention");
            validPM.then(function(data){
                ToolService.hideLoading();
                $scope.wantDelete = true;
                $scope.custommenus = angular.isArray(data) && data.length>0?data:false;
            });
        }
        $scope.doDelete = function(){
            $scope.closeWin();
            ToolService.showLoading();
            var deletePM = HttpService.deleteInfo("mng/retention/delete/"+$scope.delDefine.id);
            deletePM.then(function(){
                ToolService.showTips("删除成功");
                $scope.queryInfoByApp(3,$scope.delDefine.id);
                ToolService.hideLoading();
            });
        }

        $scope.date = ToolService.getLastDays(-7);
        $scope.disTimeFlag = [];
        $scope.rangday = -1;
        $scope.changeTimeFlag = function(flag){
            if($scope.disTimeFlag.indexOf(flag)>-1){return false;}
            // if(flag == 'day'){
            //     $scope.rangday = 15;
            // }
            // else{
            //     $scope.rangday = -1;
            // }
            $scope.timeFlag = flag;
        }
        $scope.changeTimeFlag("day");

        $scope.$on("dateCustos",function(e,msg){
            var days = diffDate(msg.startDate,msg.endDate);
            if(days>=15 || days>=60){
                $scope.disTimeFlag = ["day"];
                if($scope.timeFlag == 'day'){
                    if(days>=60){
                        $scope.timeFlag = 'month';
                    }
                    else{
                        $scope.timeFlag = 'week';
                    }
                }
            }
            else{
                if(msg.startDate == msg.endDate){
                    $scope.disTimeFlag = ["week","month"];
                    $scope.timeFlag = 'day';
                }
                else{
                    $scope.disTimeFlag = [];
                }
            }
            $scope.date = msg;
        });
        $scope.$watch("date",function(){
            if(angular.isDefined($scope.date)){
                $scope.datestr = $scope.date.startDate + "至" + $scope.date.endDate;
            }
        });

        $scope.typeList = [
            {id:'define',name:"新建自定义留存"},
            {id:'install',name:"新增留存"},
            {id:'dau',name:"活跃留存"}
        ];
        if(!$scope.hasEditPower()){
            $scope.typeList = $scope.typeList.slice(1);
        }
        $scope.clickType = function(obj){
            $scope.typesign = obj.id;
            $scope.typesname = obj.name;
            $scope.helpname = obj.name;
            $scope.define = {id:0};
            if(obj.id == 'define'){
                $scope.addModel(0);
                $scope.helpname = "自定义留存";
            }
            else{
                $scope.defineFlag = ++rmd;
                $scope.showEventWin = false;
                $scope.isShowCache = false;

                $rootScope.thirdtab = obj.name;
            }

        }

        $scope.eventInfo = [];
        $scope.dimenInit = $scope.dimenId = "-all";
        $scope.$watch("appid",function(n){
            if(angular.isDefined(n)){
                $scope.dimenId = "-all";
                $scope.lengedNames = [];
                $scope.queryInfoByApp(5);

                $scope.clickType($scope.typeList[1]);
            }
        });

        $scope.initEventInfo = function(flag,cache){
            $scope.eventInfo.filter(function(item){
                item.show = false;
            });

            if(flag==1 || cache) {//编辑
                $scope.isShowCache = flag == 0 || $scope.typesname=="新建自定义留存";
                ToolService.showLoading();
                var eventInfo = $scope.isShowCache?JSON.parse(JSON.parse(cache)):JSON.parse($scope.define.eventInfo),evts = [],evtvals = [];
                eventInfo.filter(function(item){
                    var temp = {event:item.event,param:[]};
                    var pppm = UtilService.cloneJSON(item.params);
                    pppm.filter(function(pm){
                        temp.param.push(pm.attr);
                    });
                    evts.push(item.event);
                    evtvals.push(temp);
                });
                var evtprofilePM = HttpService.getInfo($scope.appid+"/event/find/param?names="+evts.join(",")+"&params="+JSON.stringify(evtvals));
                evtprofilePM.then(function(pros){
                    pros.filter(function(evt){
                        for(var i=0;i<$scope.eventList.length;i++){
                            if(evt.eventName == $scope.eventList[i].eventName){
                                $scope.eventList[i].profiles = evt.profiles;
                                break;
                            }
                        }
                    });
                    eventInfo.filter(function(e){
                        e.oldparams = UtilService.cloneJSON(e.params);
                        delete e.params;
                        $scope.addEvent(e);
                    });
                    ToolService.hideLoading();
                });
            }
            else{
                $scope.addEvent();
                $scope.addEvent();
            }
        }

        $scope.changeRel = function(obj){
           obj.relation = obj.relation == 'and' ? "or" : 'and';
        }

        $scope.changeSeeFlag = function(flag){
            $scope.seeFlag = flag;
        }

        var rmd = new Date().getTime();
        $scope.eventinitname = "请选择事件";
        $scope.addEvent = function(obj){
            rmd ++;
            var temp = {id:"evt_"+rmd,eventid:"event_"+rmd,relation:"and",show:true};

            if(obj){
                for(var k in obj){
                    temp[k] = obj[k];
                }
                temp.eventinit = obj.event;
            }

            (function(temp){
                $scope.$on(temp.eventid,function(e,msg){
                    temp.params = [];
                    temp.event = msg.info.eventName;
                    temp.nullevent = false;

                    var setparams = function(){
                        temp.paramsList = msg.info.profiles;
                        if(temp.oldparams){
                            temp.oldparams.filter(function(item){
                                $scope.addEventParams(temp,item);
                            });
                            delete temp.oldparams;
                        }
                    }
                    if(angular.isArray(msg.info.profiles)){
                        setparams(msg.info.profiles);
                    }
                    else{
                        var proPM = HttpService.getInfo($scope.appid+"/event/find/param?names="+temp.event);
                        proPM.then(function(data){
                            msg.info.profiles = data[0].profiles;
                            setparams();
                        });
                    }
                });
            })(temp);

            if($scope.eventInfo.length % 2 == 0){
                temp.title = "初始行为";
                temp.zidx = 2;
            }else{
                temp.zidx = 1;
                temp.title = "回访行为";
            }
            $scope.eventInfo.push(temp);
        }
        $scope.closeAddWin = function(flag){
            $scope.showEventWin = false;
            if(flag == 1 && $scope.isEditInfo == 2){
                $scope.clickType($scope.typeList[1]);
            }
            $scope.isEditInfo = 1;
        }

        $scope.getEventParamsNum = function(event){
            if(!event || !event.params){return 5;}

            var eps = event.params.filter(function(item){
                return item.show!=false;
            });
            return eps.length;
        }
        $scope.addEventParams = function(event,obj){
            if(!event.params || $scope.getEventParamsNum(event)>=3){return false;};
            rmd ++;
            var tempparam = {id:"pam_"+rmd,pid:event.id};
            if(obj){
                for(var k in obj){
                    tempparam[k] = obj[k];
                }
            }
            event.params.push(tempparam);
        }
        $scope.removeEventParams = function(event,param){
            for(var i=0;i<event.params.length;i++){
                if(event.params[i].id == param.id){
                    event.params[i].show = false;
                    break;
                }
            }
        }
        $scope.initCondition = function(){
            if(!$scope.canSave()){return false;}
            $scope.initEventInfo();
        }
        $scope.$on("event",function(e,msg){
            for(var i=0;i<$scope.eventInfo.length;i++){
                if($scope.eventInfo[i].id == msg.pid){
                    var params = $scope.eventInfo[i].params;
                    for(var j=0;j<params.length;j++){
                        if(params[j].id == msg.id){
                            params[j] = msg;
                            break;
                        }
                    }
                }
            }
        });
        $scope.canSave = function(){
            if(!$scope.eventInfo || $scope.eventInfo.length == 0){return false;}

            var can = false;
            for(var i=0;i<$scope.eventInfo.length;i++){
                var temp = $scope.eventInfo[i];
                if(temp.show == true && temp.event){
                    can = true;
                    break;
                }
            }
            return can;
        }
        $scope.nowiptEvents = "";
        $scope.getEventCrm = function(islook){
            var hasNull = false;
            var eventInfo = [],myEvents = [],isnull = false;

            $scope.nowiptEvents = "";
            $scope.eventInfo.filter(function(item){
                if(item.show!=false){
                    var temp = {event:item.event,relation:item.relation,params:[]};
                    if(UtilService.isNullStr(item.event)){
                        item.nullevent = true;
                        hasNull = true;
                    }
                    else{
                        item.nullevent = false;
                        if(angular.isUndefined(item.params)){
                            isnull = true;
                        }
                        else{
                            item.params.filter(function(pm){
                                if(pm.show!=false){
                                    var pms = {};
                                    for(var k in pm){
                                        if(k!='id' && k!='pid'){
                                            if(k!='value'){
                                                pms[k] = pm[k];
                                            }else{
                                                pms[k] = pm[k].join(",");
                                            }
                                            if(UtilService.isNullStr(pm[k])){
                                                $scope.$broadcast(pm.id, "null");
                                                hasNull = true;
                                            }
                                        }
                                    }
                                    temp.params.push(pms);
                                }
                            });
                        }
                    }
                    eventInfo.push(temp);
                    myEvents.push(item.event);
                }
            });

            if(isnull){
                return false;
            }else{
                if(hasNull){
                    if(islook){
                        ToolService.showTips($scope.formTipMsg);
                    }
                }
                else{
                    $scope.nowiptEvents = JSON.stringify(eventInfo);
                }
            }

        }

        $scope.isEditInfo = 1;
        $scope.addModel = function(flag){
            var cache = UtilService.getItem("retention_"+$scope.appid);
            if(flag){
                if($scope.typesign=="install" || $scope.typesign=="dau" ||
                    ($scope.define && $scope.define.id == 0 && !cache)){return false;}
                $scope.isEditInfo = 3;
            }else{
                $scope.isEditInfo = 2;
            }
            $scope.initEventInfo(flag,cache);
            $scope.showEventWin = true;
        }

        $scope.nameWin = function(flag){
            $scope.getEventCrm();
            if($scope.nowiptEvents==''){
                ToolService.hideLoading();
                ToolService.showTips($scope.formTipMsg);
                return false;
            }

            ToolService.showAlp();
            $scope.wantSave = true;

            $scope.currentDefine = {};
            $scope.ename = "";
            if(angular.isDefined(flag)){ //编辑
                $scope.currentDefine = $scope.define;
                $scope.define = {id:0};
            }
        }
        $scope.lookReport = function(){
            if(!$scope.canSave()){return false;}

            $scope.getEventCrm(true);
            if($scope.nowiptEvents!=''){
                $scope.showEventWin = false;
                $scope.query(true);
            }
        }
        $scope.closeWin = function(flag){
            $scope.wantSave = false;
            $scope.wantDelete = false;

            if(flag){
                if(flag == 1){
                    $scope.showEventWin = false;
                }

                if(flag == 2 && $scope.isEditInfo == 3){
                    $scope.define = $scope.currentDefine;
                }
            }
            $scope.isEditInfo = 1;
            ToolService.hideAlp();
        }
        $scope.save = function(){
            $scope.getEventCrm();
            if($scope.nowiptEvents==''){return false;}

            var doSave = function(){
                var par = {
                    app : $scope.appid,
                    eventInfo: $scope.nowiptEvents,
                    name : $scope.ename
                }

                var savePM = null,txtTips = "添加成功",flag=1;
                if($scope.define.id>0){
                    par.id = $scope.define.id;
                    savePM = HttpService.putInfo("mng/retention/update",par);
                    txtTips = "修改成功";
                    flag = 2;
                }else{
                    savePM = HttpService.postInfo("mng/retention/create",par);
                }
                ToolService.showLoading();
                savePM.then(function(data){
                    $scope.closeWin(1);
                    ToolService.hideLoading();
                    ToolService.showTips(txtTips);
                    $scope.queryInfoByApp(flag,par.id);
                    if($scope.isShowCache){
                        localStorage.removeItem("retention_"+$scope.appid);
                        $scope.isShowCache = false;
                    }
                });
            }

            if($scope.define.id == 0){
                var verPar = {
                    name: {
                        key: 'spcname',
                        val: $scope.ename
                    }
                };
                $scope.tip = formJudge(verPar);
                if(UtilService.isNullStr($scope.ename) || $scope.tip.succ != true){
                    ToolService.showTips("请输入20个汉字以内名称，允许字符为中英文数字_-");
                    return false;
                }
                else{
                    ToolService.showLoading();
                    var existPM = HttpService.getInfo("mng/retention/valid/"+$scope.appid,{name:$scope.ename});
                    existPM.then(function(data){
                        if(data==true){
                            ToolService.hideLoading();
                            ToolService.showTips("名称已存在");
                        }
                        else{
                           doSave();
                        }
                    });
                }
            }else{
                doSave();
            }
        }

        var getParams = function(){
            var params = {
                    reportview:$scope.timeFlag,
                    retentiontype:$scope.typesign,
                    appid : $scope.appid
                };
            if($scope.isTempLook || $scope.isShowCache){
                $scope.getEventCrm();

                if($scope.nowiptEvents==''){return -1;}
                params.eventinfo = $scope.nowiptEvents;
                UtilService.setItem("retention_"+$scope.appid,JSON.stringify($scope.nowiptEvents));
                $scope.isShowCache = true;
            }
            else if($scope.define && $scope.define.id>0){
                params.eventinfo = $scope.define.eventInfo;
            }
            else if($scope.typesign == 'define'){
                return -2;
            }

            params.startdate = $scope.date.startDate;
            params.enddate = $scope.date.endDate;
            params.datatype = "list";
            params.eventType = $scope.dimenEventType;

            return params;
        }

        $scope.retetionConfig = {color:ToolService.getTenColors(),ispercent:true,legend:false};
        var maxRet = 0,maxDetailRet = 0;
        $scope.query = function(istemp){
            if(istemp){
                $scope.isTempLook = true;
            }
            else{
                $scope.isTempLook = false;
            }

            var params = getParams();
            if(params == -1){return false;}
            if(params == -2){
                $scope.clickType($scope.typeList[1]);
                return false;
            }

            params.datatype = "list";

            /*if($scope.dimenId && $scope.dimenId!='-all' && $scope.showDemistion()){
                params.dimention = $scope.dimenId;
                if(params.dimention == 'usergroup'){
                    if($scope.usergroupid==-1){return false;}
                    params.usergroupid = $scope.usergroupid;
                }
            }*/
            params.dimention = $scope.dimenId;
            if(params.dimention == 'usergroup'){
                if($scope.usergroupid==-1){return false;}
                params.usergroupid = $scope.usergroupid;
            }


            params.isdevice = $scope.seeFlag == 'device';
            params.eventType = $scope.dimenEventType;

            var retetionPM = null, areport = "", expType = "", ddID = "", ddName = ($scope.define.name || $scope.typesname) + "的留存趋势详情";
            if($scope.define && $scope.define.id>0){
                ddID = $scope.define.id;
            }
            var view = 'ds';
            if($scope.timeFlag != 'day'){
                view = $scope.timeFlag;
            }
            var myreport = "retention/report/"+$scope.appid;
            areport = myreport;
            expType = "customretention";
            if($scope.typesign!='define' && $scope.typesign != 'dau'){
                //新增留存
                params.eventinfo = "payment,loggedin,reged";
            }
            else if($scope.typesign=='dau'){
                params.retentiontype = 'active';
            }else{
                //自定义
            }
            retetionPM = HttpService.getInfo(myreport,params);
            $scope.retetionLoading = true;
            $scope.showDetail = false;
            $scope.infolistLoading = true;
            retetionPM.then(function(data){
                $scope.infolist = data;
                if(params.dimention){
                    $scope.infolist.name[0] = $scope.dimenObj.name;
                }

                var infoVal = data.val;
                $scope.infolistLoading = false;

                var chartData = {
                    name:[],
                    key:[],
                    val:[],
                    rmd: ++rmd
                };
                if(infoVal.length>0){
                    chartData.key = data.key.slice(1);

                    var columns = data.columnkey;
                    infoVal.filter(function(item){
                        chartData.name.push(item[columns[0]]);

                        var linedata = [];
                        for(var i=2;i<columns.length;i++){
                            linedata.push(item['rate_'+columns[i]]);
                        }
                        chartData.val.push(linedata);
                    });
                }
                else{
                    if($scope.dimenId == 'usergroup' && $scope.lengedNames && $scope.lengedNames.length>1){
                        chartData.name = ['整体',$scope.lengedNames[$scope.userIndex]];
                    }
                }

                $scope.eventChartData = chartData;
                if(params.dimention != 'usergroup'){
                    $scope.lengedNames = chartData.name;
                }

                var max = 5;
                if(chartData.name.length > max){
                    $scope.myChartData = {
                        name:chartData.name.slice(0,max),
                        key:chartData.key,
                        val:chartData.val.slice(0,max),
                        rmd: ++rmd
                    };
                }
                else{
                    $scope.myChartData = UtilService.cloneJSON(chartData);
                }

                maxRet = 0;
                var k = data.columnkey[2];
                data.val.filter(function(item){
                    if(item[k] > maxRet){
                        maxRet = item['rate_'+k];
                    }
                });

                $scope.retetionLoading = false;
                $scope.myChartDataCondition = ToolService.getChartConditions(ddName,areport,params,expType,ddID);
            },function(data){
                // $scope.errorBack(data.message);
                $scope.myChartData = ToolService.noDataChart();
                $scope.infolist = {};
                $scope.retetionLoading = false;
                $scope.infolistLoading = false;
            });
        }
        var lengedMax = 10;
        $scope.changeChartData = function(n){
            if(!$scope.myChartData){return false;}

            if($scope.dimenId == 'usergroup'){
                var idx = $scope.lengedNames.indexOf(n);
                if(idx > 0 && $scope.dimenugkeys.indexOf($scope.usergroupid) != idx){
                    $scope.usergroupid = $scope.dimenugkeys[idx];
                    $scope.userIndex = idx;
                    return false;
                }
                else if(idx == 0){
                    ToolService.showTips("整体不可取消");
                    return false;
                }
            }

            var namelen = $scope.myChartData.name.length,idx = $scope.myChartData.name.indexOf(n);

            if(idx>-1){ //删除该线
                var tempData = UtilService.cloneJSON($scope.myChartData);
                tempData.name.splice(idx,1);
                tempData.val.splice(idx,1);
                tempData.rmd = ++rmd;

                $scope.myChartData = tempData;
            }
            if(namelen < lengedMax && idx == -1){ //加入
                var pidx = $scope.eventChartData.name.indexOf(n);
                 var tempData = UtilService.cloneJSON($scope.myChartData);
                tempData.name.push(n);
                tempData.val.push($scope.eventChartData.val[pidx]);
                tempData.rmd = ++rmd;

                $scope.myChartData = tempData;
            }
        }
        $scope.lengedBgStyle = function(n){
            var idx = $scope.myChartData.name.indexOf(n);
            if(idx>-1){
                return {"background-color":$scope.retetionConfig.color[idx],"border-color":"transparent"};
            }
            else{
                return {};
            }
        }
        $scope.lengedClass = function(n){
            if(!$scope.myChartData){return "";}

            var namelen = $scope.myChartData.name.length,idx = $scope.myChartData.name.indexOf(n);
            if(namelen>=lengedMax && idx==-1){
                return 'disable';
            }
            else{
                return "";
            }
        }
        $scope.getBgColor = function(opa,idx,flag){
            if(idx<1){return {};}

            if(flag == 1 && maxRet > 0){
                opa = Number((opa/maxRet).toFixed(2))*0.8;
            }
            else if(flag == 2 && maxDetailRet > 0){
                opa = Number((opa/maxDetailRet).toFixed(2))*0.8;
            }
            else{
                opa = 0;
            }

            var color = "rgba(109,199,190,"+opa+")";
            return {'background-color':color};
        }

        $scope.subDetail = function(info,idx){
            if(idx>0){return false;}

            var nk = $scope.infolist.columnkey[0];
            $scope.detailInfoTitle = info[nk];
            $scope.detailInfoLoading = true;
            $scope.showDetail = true;

            var params = getParams();
            var detailPM = null;
            $scope.detailInfo = [];

            params.isdevice = $scope.seeFlag == 'device';

            var myreport = "",expType = "",ddID = "";
            expType = "detailcustomretention";
            if($scope.typesign!='define' && $scope.typesign != 'dau'){
                var view = 'ds';
                if($scope.timeFlag != 'day'){
                    view = $scope.timeFlag;
                }
                params.isdetail = true;
                /*myreport = "retention_" + $scope.typesign + "_dau_by" + view;  整体*/
                myreport = "reportdetail/"+$scope.appid;

            }else if($scope.typesign == 'dau'){
                params.retentiontype = "active";
            }
            else{
                if($scope.define && $scope.define.id>0){
                    ddID = $scope.define.id;
                }
            }
            //第一个整体不传参数
            if($scope.detailInfoTitle != '整体'){
                if($scope.dimenId && $scope.dimenId!='-all'){
                    if($scope.dimenId == 'usergroup'){
                        params.usergroupid = $scope.usergroupid;
                    }
                    else{
                        var json = {};
                        json[$scope.dimenId] = info[$scope.dimenId+"_key"];
                        json.type = $scope.dimenObj.type;
                        params.dimention = JSON.stringify(json);
                    }
                }
            }

            var areport = "";
            if($scope.typesign!='define' && $scope.typesign != 'dau'){
                areport = myreport;
                params.eventinfo = "payment,loggedin,reged";
                detailPM = HttpService.getInfo('retention/'+myreport,params);
            }else if($scope.typesign == 'dau'){
                areport = "retention/reportdetail/"+$scope.appid;
                params.eventinfo = "payment,loggedin,reged";
                detailPM = HttpService.getInfo(areport,params);
            }
            else{
                areport = "retention/reportdetail/"+$scope.appid;
                detailPM = HttpService.getInfo(areport,params);
            }
            params.eventType = $scope.dimenEventType;

            detailPM.then(function(data){
                $scope.detailInfo = data;
                $scope.detailInfoLoading = false;

                maxDetailRet = 0;
                var k = data.columnkey[2];
                data.val.filter(function(item){
                    if(item[k] > maxDetailRet){
                        maxDetailRet = item['rate_'+k];
                    }
                });
                $scope.detailInfoCondition = ToolService.getChartConditions(($scope.define.name || $scope.typesname)+"的留存明细",areport,params,expType,ddID);
            },function(data){
                // $scope.errorBack(data.message);
                $scope.detailInfoLoading = false;
            });
        }

        $scope.$watch("appid+date.startDate+date.endDate+seeFlag+timeFlag+dimenId+defineFlag+usergroupid",function(){
            if(angular.isDefined($scope.appid) && angular.isDefined($scope.date) && angular.isDefined($scope.typesign)){
                $scope.query();
            }
        });
    }
})();
