/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.client.transform;

import com.dianping.cat.configuration.client.IVisitor;
import com.dianping.cat.configuration.client.entity.Bind;
import com.dianping.cat.configuration.client.entity.ClientConfig;
import com.dianping.cat.configuration.client.entity.Domain;
import com.dianping.cat.configuration.client.entity.Property;
import com.dianping.cat.configuration.client.entity.Server;
import java.util.Stack;

public class DefaultValidator
implements IVisitor {
    private Path m_path = new Path();

    protected void assertRequired(String name, Object value) {
        if (value == null) {
            throw new RuntimeException(String.format("%s at path(%s) is required!", name, this.m_path));
        }
    }

    public void visitBind(Bind bind) {
    }

    public void visitConfig(ClientConfig config) {
        this.m_path.down("config");
        this.assertRequired("mode", config.getMode());
        this.visitConfigChildren(config);
        this.m_path.up("config");
    }

    protected void visitConfigChildren(ClientConfig config) {
        this.m_path.down("servers");
        for (Server server : config.getServers()) {
            this.visitServer(server);
        }
        this.m_path.up("servers");
        for (Domain domain : config.getDomains().values()) {
            this.visitDomain(domain);
        }
        if (config.getBind() != null) {
            this.visitBind(config.getBind());
        }
        this.m_path.down("properties");
        for (Property property : config.getProperties().values()) {
            this.visitProperty(property);
        }
        this.m_path.up("properties");
    }

    public void visitDomain(Domain domain) {
        this.m_path.down("domain");
        this.assertRequired("id", domain.getId());
        this.m_path.up("domain");
    }

    public void visitProperty(Property property) {
        this.m_path.down("property");
        this.assertRequired("name", property.getName());
        this.m_path.up("property");
    }

    public void visitServer(Server server) {
        this.m_path.down("server");
        this.assertRequired("ip", server.getIp());
        this.m_path.up("server");
    }

    static class Path {
        private Stack<String> m_sections = new Stack();

        Path() {
        }

        public Path down(String nextSection) {
            this.m_sections.push(nextSection);
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (String section : this.m_sections) {
                sb.append('/').append(section);
            }
            return sb.toString();
        }

        public Path up(String currentSection) {
            if (this.m_sections.isEmpty() || !this.m_sections.peek().equals(currentSection)) {
                throw new RuntimeException("INTERNAL ERROR: stack mismatched!");
            }
            this.m_sections.pop();
            return this;
        }
    }
}

