/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.server.entity;

import com.dianping.cat.configuration.server.BaseEntity;
import com.dianping.cat.configuration.server.IVisitor;
import com.dianping.cat.configuration.server.entity.HdfsConfig;
import com.dianping.cat.configuration.server.entity.Property;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageConfig
extends BaseEntity<StorageConfig> {
    private String m_localBaseDir = "target/bucket";
    private Boolean m_hdfsDisabled;
    private Map<String, HdfsConfig> m_hdfses = new LinkedHashMap<String, HdfsConfig>();
    private Map<String, Property> m_properties = new LinkedHashMap<String, Property>();
    private int m_uploadThread = 5;
    private int m_maxHdfsStorageTime = 15;
    private int m_localReportStorageTime = 3;
    private int m_localLogivewStorageTime = 7;

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitStorage(this);
    }

    public StorageConfig addHdfs(HdfsConfig hdfs) {
        this.m_hdfses.put(hdfs.getId(), hdfs);
        return this;
    }

    public StorageConfig addProperty(Property property) {
        this.m_properties.put(property.getName(), property);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StorageConfig) {
            StorageConfig _o = (StorageConfig)obj;
            if (!this.equals(this.getLocalBaseDir(), _o.getLocalBaseDir())) {
                return false;
            }
            if (!this.equals(this.getHdfsDisabled(), _o.getHdfsDisabled())) {
                return false;
            }
            if (!this.equals(this.getHdfses(), _o.getHdfses())) {
                return false;
            }
            if (!this.equals(this.getProperties(), _o.getProperties())) {
                return false;
            }
            if (this.getUploadThread() != _o.getUploadThread()) {
                return false;
            }
            if (this.getMaxHdfsStorageTime() != _o.getMaxHdfsStorageTime()) {
                return false;
            }
            if (this.getLocalReportStorageTime() != _o.getLocalReportStorageTime()) {
                return false;
            }
            return this.getLocalLogivewStorageTime() == _o.getLocalLogivewStorageTime();
        }
        return false;
    }

    public HdfsConfig findHdfs(String id) {
        return this.m_hdfses.get(id);
    }

    public Property findProperty(String name) {
        return this.m_properties.get(name);
    }

    public Boolean getHdfsDisabled() {
        return this.m_hdfsDisabled;
    }

    public Map<String, HdfsConfig> getHdfses() {
        return this.m_hdfses;
    }

    public String getLocalBaseDir() {
        return this.m_localBaseDir;
    }

    public int getLocalLogivewStorageTime() {
        return this.m_localLogivewStorageTime;
    }

    public int getLocalReportStorageTime() {
        return this.m_localReportStorageTime;
    }

    public int getMaxHdfsStorageTime() {
        return this.m_maxHdfsStorageTime;
    }

    public Map<String, Property> getProperties() {
        return this.m_properties;
    }

    public int getUploadThread() {
        return this.m_uploadThread;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_localBaseDir == null ? 0 : this.m_localBaseDir.hashCode());
        hash = hash * 31 + (this.m_hdfsDisabled == null ? 0 : this.m_hdfsDisabled.hashCode());
        hash = hash * 31 + (this.m_hdfses == null ? 0 : this.m_hdfses.hashCode());
        hash = hash * 31 + (this.m_properties == null ? 0 : this.m_properties.hashCode());
        hash = hash * 31 + this.m_uploadThread;
        hash = hash * 31 + this.m_maxHdfsStorageTime;
        hash = hash * 31 + this.m_localReportStorageTime;
        hash = hash * 31 + this.m_localLogivewStorageTime;
        return hash;
    }

    public boolean isHdfsDisabled() {
        return this.m_hdfsDisabled != null && this.m_hdfsDisabled != false;
    }

    @Override
    public void mergeAttributes(StorageConfig other) {
        if (other.getLocalBaseDir() != null) {
            this.m_localBaseDir = other.getLocalBaseDir();
        }
        if (other.getHdfsDisabled() != null) {
            this.m_hdfsDisabled = other.getHdfsDisabled();
        }
        this.m_uploadThread = other.getUploadThread();
        this.m_maxHdfsStorageTime = other.getMaxHdfsStorageTime();
        this.m_localReportStorageTime = other.getLocalReportStorageTime();
        this.m_localLogivewStorageTime = other.getLocalLogivewStorageTime();
    }

    public HdfsConfig removeHdfs(String id) {
        return this.m_hdfses.remove(id);
    }

    public Property removeProperty(String name) {
        return this.m_properties.remove(name);
    }

    public StorageConfig setHdfsDisabled(Boolean hdfsDisabled) {
        this.m_hdfsDisabled = hdfsDisabled;
        return this;
    }

    public StorageConfig setLocalBaseDir(String localBaseDir) {
        this.m_localBaseDir = localBaseDir;
        return this;
    }

    public StorageConfig setLocalLogivewStorageTime(int localLogivewStorageTime) {
        this.m_localLogivewStorageTime = localLogivewStorageTime;
        return this;
    }

    public StorageConfig setLocalReportStorageTime(int localReportStorageTime) {
        this.m_localReportStorageTime = localReportStorageTime;
        return this;
    }

    public StorageConfig setMaxHdfsStorageTime(int maxHdfsStorageTime) {
        this.m_maxHdfsStorageTime = maxHdfsStorageTime;
        return this;
    }

    public StorageConfig setUploadThread(int uploadThread) {
        this.m_uploadThread = uploadThread;
        return this;
    }
}

