/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.server.transform;

import com.dianping.cat.configuration.server.IEntity;
import com.dianping.cat.configuration.server.entity.ConsoleConfig;
import com.dianping.cat.configuration.server.entity.ConsumerConfig;
import com.dianping.cat.configuration.server.entity.Domain;
import com.dianping.cat.configuration.server.entity.HdfsConfig;
import com.dianping.cat.configuration.server.entity.Ldap;
import com.dianping.cat.configuration.server.entity.LongConfig;
import com.dianping.cat.configuration.server.entity.Property;
import com.dianping.cat.configuration.server.entity.ServerConfig;
import com.dianping.cat.configuration.server.entity.StorageConfig;
import com.dianping.cat.configuration.server.transform.DefaultLinker;
import com.dianping.cat.configuration.server.transform.DefaultSaxMaker;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static ServerConfig parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(ServerConfig.class, new InputSource(DefaultSaxParser.removeBOM(in)));
    }

    public static ServerConfig parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(ServerConfig.class, new InputSource(DefaultSaxParser.removeBOM(reader)));
    }

    public static ServerConfig parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(ServerConfig.class, new InputSource(new StringReader(DefaultSaxParser.removeBOM(xml))));
    }

    private static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(type, new InputSource(DefaultSaxParser.removeBOM(in)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(type, new InputSource(new StringReader(DefaultSaxParser.removeBOM(xml))));
    }

    private static <T> T removeBOM(T obj) throws IOException {
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.length() != 0 && str.charAt(0) == '\ufeff') {
                return (T)str.substring(1);
            }
            return obj;
        }
        if (obj instanceof InputStream) {
            BufferedInputStream in = new BufferedInputStream((InputStream)obj);
            in.mark(3);
            if (in.read() != 239 || in.read() != 187 || in.read() != 191) {
                in.reset();
            }
            return (T)in;
        }
        if (obj instanceof Reader) {
            BufferedReader in = new BufferedReader((Reader)obj);
            in.mark(1);
            if (in.read() != 65279) {
                in.reset();
            }
            return (T)in;
        }
        return obj;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            Object currentObj = this.m_objs.pop();
            String currentTag = this.m_tags.pop();
            if (currentObj instanceof ConsoleConfig) {
                ConsoleConfig console = (ConsoleConfig)currentObj;
                if ("remote-servers".equals(currentTag)) {
                    console.setRemoteServers(this.getText());
                }
            }
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForConfig(ServerConfig parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("storage".equals(qName)) {
            StorageConfig storage = this.m_maker.buildStorage(attributes);
            this.m_linker.onStorage(parentObj, storage);
            this.m_objs.push(storage);
        } else if ("consumer".equals(qName)) {
            ConsumerConfig consumer = this.m_maker.buildConsumer(attributes);
            this.m_linker.onConsumer(parentObj, consumer);
            this.m_objs.push(consumer);
        } else if ("console".equals(qName)) {
            ConsoleConfig console = this.m_maker.buildConsole(attributes);
            this.m_linker.onConsole(parentObj, console);
            this.m_objs.push(console);
        } else if ("ldap".equals(qName)) {
            Ldap ldap = this.m_maker.buildLdap(attributes);
            this.m_linker.onLdap(parentObj, ldap);
            this.m_objs.push(ldap);
        } else if ("property".equals(qName)) {
            Property property = this.m_maker.buildProperty(attributes);
            this.m_linker.onProperty(parentObj, property);
            this.m_objs.push(property);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under config!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForConsole(ConsoleConfig parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"remote-servers".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under console!", qName));
        }
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForConsumer(ConsumerConfig parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"long-config".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under consumer!", qName));
        }
        LongConfig longConfig = this.m_maker.buildLongConfig(attributes);
        this.m_linker.onLongConfig(parentObj, longConfig);
        this.m_objs.push(longConfig);
        this.m_tags.push(qName);
    }

    private void parseForDomain(Domain parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForHdfs(HdfsConfig parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForLdap(Ldap parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForLongConfig(LongConfig parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"domain".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under long-config!", qName));
        }
        Domain domain = this.m_maker.buildDomain(attributes);
        this.m_linker.onDomain(parentObj, domain);
        this.m_objs.push(domain);
        this.m_tags.push(qName);
    }

    private void parseForProperty(Property parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForStorage(StorageConfig parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("properties".equals(qName)) {
            this.m_objs.push(parentObj);
        } else if ("hdfs".equals(qName)) {
            HdfsConfig hdfs = this.m_maker.buildHdfs(attributes);
            this.m_linker.onHdfs(parentObj, hdfs);
            this.m_objs.push(hdfs);
        } else if ("property".equals(qName)) {
            Property property = this.m_maker.buildProperty(attributes);
            this.m_linker.onProperty(parentObj, property);
            this.m_objs.push(property);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under storage!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("config".equals(qName)) {
            ServerConfig config;
            this.m_entity = config = this.m_maker.buildConfig(attributes);
            this.m_objs.push(config);
            this.m_tags.push(qName);
        } else if ("storage".equals(qName)) {
            StorageConfig storage;
            this.m_entity = storage = this.m_maker.buildStorage(attributes);
            this.m_objs.push(storage);
            this.m_tags.push(qName);
        } else if ("hdfs".equals(qName)) {
            HdfsConfig hdfs;
            this.m_entity = hdfs = this.m_maker.buildHdfs(attributes);
            this.m_objs.push(hdfs);
            this.m_tags.push(qName);
        } else if ("property".equals(qName)) {
            Property property;
            this.m_entity = property = this.m_maker.buildProperty(attributes);
            this.m_objs.push(property);
            this.m_tags.push(qName);
        } else if ("consumer".equals(qName)) {
            ConsumerConfig consumer;
            this.m_entity = consumer = this.m_maker.buildConsumer(attributes);
            this.m_objs.push(consumer);
            this.m_tags.push(qName);
        } else if ("long-config".equals(qName)) {
            LongConfig longConfig;
            this.m_entity = longConfig = this.m_maker.buildLongConfig(attributes);
            this.m_objs.push(longConfig);
            this.m_tags.push(qName);
        } else if ("domain".equals(qName)) {
            Domain domain;
            this.m_entity = domain = this.m_maker.buildDomain(attributes);
            this.m_objs.push(domain);
            this.m_tags.push(qName);
        } else if ("console".equals(qName)) {
            ConsoleConfig console;
            this.m_entity = console = this.m_maker.buildConsole(attributes);
            this.m_objs.push(console);
            this.m_tags.push(qName);
        } else if ("ldap".equals(qName)) {
            Ldap ldap;
            this.m_entity = ldap = this.m_maker.buildLdap(attributes);
            this.m_objs.push(ldap);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = this.m_tags.peek();
            if (parent instanceof ServerConfig) {
                this.parseForConfig((ServerConfig)parent, tag, qName, attributes);
            } else if (parent instanceof StorageConfig) {
                this.parseForStorage((StorageConfig)parent, tag, qName, attributes);
            } else if (parent instanceof HdfsConfig) {
                this.parseForHdfs((HdfsConfig)parent, tag, qName, attributes);
            } else if (parent instanceof Property) {
                this.parseForProperty((Property)parent, tag, qName, attributes);
            } else if (parent instanceof ConsumerConfig) {
                this.parseForConsumer((ConsumerConfig)parent, tag, qName, attributes);
            } else if (parent instanceof LongConfig) {
                this.parseForLongConfig((LongConfig)parent, tag, qName, attributes);
            } else if (parent instanceof Domain) {
                this.parseForDomain((Domain)parent, tag, qName, attributes);
            } else if (parent instanceof ConsoleConfig) {
                this.parseForConsole((ConsoleConfig)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof Ldap)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForLdap((Ldap)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

