/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.web.js.transform;

import com.dianping.cat.configuration.web.js.entity.Aggregation;
import com.dianping.cat.configuration.web.js.entity.AggregationRule;
import com.dianping.cat.configuration.web.js.transform.IMaker;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSaxMaker
implements IMaker<Attributes> {
    @Override
    public Aggregation buildAggregation(Attributes attributes) {
        Aggregation aggregation = new Aggregation();
        return aggregation;
    }

    @Override
    public AggregationRule buildAggregationRule(Attributes attributes) {
        String type = attributes.getValue("type");
        String domain = attributes.getValue("domain");
        String pattern = attributes.getValue("pattern");
        String sample = attributes.getValue("sample");
        String displayName = attributes.getValue("display-name");
        String creationDate = attributes.getValue("creation-date");
        String warn = attributes.getValue("warn");
        String mails = attributes.getValue("mails");
        AggregationRule aggregationRule = new AggregationRule(pattern);
        if (type != null) {
            aggregationRule.setType(this.convert(Integer.class, type, 0));
        }
        if (domain != null) {
            aggregationRule.setDomain(domain);
        }
        if (sample != null) {
            aggregationRule.setSample(sample);
        }
        if (displayName != null) {
            aggregationRule.setDisplayName(displayName);
        }
        if (creationDate != null) {
            aggregationRule.setCreationDate(this.toDate(creationDate, "yyyy-MM-dd HH:mm:ss", null));
        }
        if (warn != null) {
            aggregationRule.setWarn(this.convert(Integer.class, warn, 0));
        }
        if (mails != null) {
            aggregationRule.setMails(mails);
        }
        return aggregationRule;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    protected Date toDate(String str, String format, Date defaultValue) {
        if (str == null || str.length() == 0) {
            return defaultValue;
        }
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }
}

