/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.ReportBucket;
import com.dianping.cat.report.ReportBucketManager;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.unidal.helper.Scanners;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReportBucketManager
extends ContainerHolder
implements ReportBucketManager,
Initializable {
    @Inject
    private ServerConfigManager m_configManager;
    private String m_reportBaseDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearOldReports() {
        Transaction t = Cat.newTransaction((String)"System", (String)"DeleteReport");
        try {
            File reportDir = new File(this.m_reportBaseDir);
            final ArrayList toRemovePaths = new ArrayList();
            final Set<String> validPaths = this.queryValidPath(this.m_configManager.getLocalReportStroageTime());
            Scanners.forDir().scan(reportDir, (Scanners.IMatcher)new Scanners.FileMatcher(){

                public Scanners.IMatcher.Direction matches(File base, String path) {
                    File file = new File(base, path);
                    if (file.isFile() && this.shouldDeleteReport(path)) {
                        toRemovePaths.add(path);
                    }
                    return Scanners.IMatcher.Direction.DOWN;
                }

                private boolean shouldDeleteReport(String path) {
                    for (String str : validPaths) {
                        if (!path.contains(str)) continue;
                        return false;
                    }
                    return true;
                }
            });
            for (String path : toRemovePaths) {
                File file = new File(this.m_reportBaseDir, path);
                file.delete();
                Cat.logEvent((String)"System", (String)"DeleteReport", (String)"0", (String)file.getAbsolutePath());
            }
            this.removeEmptyDir(reportDir);
            t.setStatus("0");
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            t.setStatus((Throwable)e);
        }
        finally {
            t.complete();
        }
    }

    @Override
    public void closeBucket(ReportBucket bucket) {
        try {
            bucket.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.release(bucket);
        }
    }

    @Override
    public ReportBucket getReportBucket(long timestamp, String name, int index) throws IOException {
        Date date = new Date(timestamp);
        ReportBucket bucket = (ReportBucket)this.lookup(ReportBucket.class);
        bucket.initialize(name, date, index);
        return bucket;
    }

    public void initialize() throws InitializationException {
        this.m_reportBaseDir = this.m_configManager.getHdfsLocalBaseDir("report");
    }

    private Set<String> queryValidPath(int day) {
        HashSet<String> strs = new HashSet<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        long currentTimeMillis = System.currentTimeMillis();
        for (int i = 0; i < day; ++i) {
            Date date = new Date(currentTimeMillis - (long)(i * 24 * 60 * 60) * 1000L);
            strs.add(sdf.format(date));
        }
        return strs;
    }

    private void removeEmptyDir(File baseFile) {
        for (int i = 0; i < 2; ++i) {
            final ArrayList directionPaths = new ArrayList();
            Scanners.forDir().scan(baseFile, (Scanners.IMatcher)new Scanners.FileMatcher(){

                public Scanners.IMatcher.Direction matches(File base, String path) {
                    if (new File(base, path).isDirectory()) {
                        directionPaths.add(path);
                    }
                    return Scanners.IMatcher.Direction.DOWN;
                }
            });
            for (String path : directionPaths) {
                try {
                    File file = new File(baseFile, path);
                    file.delete();
                }
                catch (Exception exception) {}
            }
        }
    }
}

