/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.service;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportContent;
import com.dianping.cat.core.dal.DailyReportContentDao;
import com.dianping.cat.core.dal.DailyReportDao;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentDao;
import com.dianping.cat.core.dal.HourlyReportDao;
import com.dianping.cat.core.dal.HourlyReportEntity;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.MonthlyReportContent;
import com.dianping.cat.core.dal.MonthlyReportContentDao;
import com.dianping.cat.core.dal.MonthlyReportDao;
import com.dianping.cat.core.dal.MonthlyReportEntity;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.core.dal.WeeklyReportContent;
import com.dianping.cat.core.dal.WeeklyReportContentDao;
import com.dianping.cat.core.dal.WeeklyReportDao;
import com.dianping.cat.core.dal.WeeklyReportEntity;
import com.dianping.cat.report.service.ReportService;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.logging.LogEnabled;
import org.unidal.lookup.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReportService<T>
implements LogEnabled,
ReportService<T> {
    @Inject
    protected HourlyReportDao m_hourlyReportDao;
    @Inject
    protected HourlyReportContentDao m_hourlyReportContentDao;
    @Inject
    protected DailyReportDao m_dailyReportDao;
    @Inject
    protected DailyReportContentDao m_dailyReportContentDao;
    @Inject
    protected WeeklyReportDao m_weeklyReportDao;
    @Inject
    protected WeeklyReportContentDao m_weeklyReportContentDao;
    @Inject
    protected MonthlyReportDao m_monthlyReportDao;
    @Inject
    protected MonthlyReportContentDao m_monthlyReportContentDao;
    private Map<String, Set<String>> m_domains = new LinkedHashMap<String, Set<String>>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Set<String>> eldest) {
            return this.size() > 1000;
        }
    };
    protected Logger m_logger;
    public static final int s_hourly = 1;
    public static final int s_daily = 2;
    public static final int s_weekly = 3;
    public static final int s_monthly = 4;
    public static final int s_customer = 5;

    @Override
    public boolean insertDailyReport(DailyReport report, byte[] content) {
        try {
            this.m_dailyReportDao.insert(report);
            int id = report.getId();
            DailyReportContent proto = this.m_dailyReportContentDao.createLocal();
            proto.setReportId(id);
            proto.setContent(content);
            this.m_dailyReportContentDao.insert(proto);
            return true;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean insertHourlyReport(HourlyReport report, byte[] content) {
        try {
            this.m_hourlyReportDao.insert(report);
            int id = report.getId();
            HourlyReportContent proto = this.m_hourlyReportContentDao.createLocal();
            proto.setReportId(id);
            proto.setContent(content);
            this.m_hourlyReportContentDao.insert(proto);
            return true;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean insertMonthlyReport(MonthlyReport report, byte[] content) {
        try {
            MonthlyReport monthReport = this.m_monthlyReportDao.findReportByDomainNamePeriod(report.getPeriod(), report.getDomain(), report.getName(), MonthlyReportEntity.READSET_FULL);
            if (monthReport != null) {
                MonthlyReportContent reportContent = this.m_monthlyReportContentDao.createLocal();
                reportContent.setKeyReportId(monthReport.getId());
                reportContent.setReportId(monthReport.getId());
                this.m_monthlyReportDao.deleteReportByDomainNamePeriod(report);
                this.m_monthlyReportContentDao.deleteByPK(reportContent);
            }
        }
        catch (DalNotFoundException monthReport) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        try {
            this.m_monthlyReportDao.insert(report);
            int id = report.getId();
            MonthlyReportContent proto = this.m_monthlyReportContentDao.createLocal();
            proto.setReportId(id);
            proto.setContent(content);
            this.m_monthlyReportContentDao.insert(proto);
            return true;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    @Override
    public boolean insertWeeklyReport(WeeklyReport report, byte[] content) {
        try {
            WeeklyReport weeklyReport = this.m_weeklyReportDao.findReportByDomainNamePeriod(report.getPeriod(), report.getDomain(), report.getName(), WeeklyReportEntity.READSET_FULL);
            if (weeklyReport != null) {
                WeeklyReportContent reportContent = this.m_weeklyReportContentDao.createLocal();
                reportContent.setKeyReportId(weeklyReport.getId());
                reportContent.setReportId(weeklyReport.getId());
                this.m_weeklyReportContentDao.deleteByPK(reportContent);
                this.m_weeklyReportDao.deleteReportByDomainNamePeriod(report);
            }
        }
        catch (DalNotFoundException weeklyReport) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        try {
            this.m_weeklyReportDao.insert(report);
            int id = report.getId();
            WeeklyReportContent proto = this.m_weeklyReportContentDao.createLocal();
            proto.setReportId(id);
            proto.setContent(content);
            this.m_weeklyReportContentDao.insert(proto);
            return true;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public int computeQueryType(Date start, Date end) {
        long duration = end.getTime() - start.getTime();
        if (duration == 3600000L) {
            return 1;
        }
        if (duration == 86400000L) {
            return 2;
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(start);
        if (duration == 604800000L && startCal.get(7) == 7) {
            return 3;
        }
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(end);
        if (startCal.get(5) == 1 && endCal.get(5) == 1) {
            return 4;
        }
        return 5;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public abstract T makeReport(String var1, Date var2, Date var3);

    @Override
    public Set<String> queryAllDomainNames(Date start, Date end, String name) {
        HashSet<String> domains = new HashSet<String>();
        long endTime = end.getTime();
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            domains.addAll(this.queryAllDomains(new Date(startTime), name));
        }
        return domains;
    }

    private Set<String> queryAllDomains(Date date, String name) {
        String key = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(date) + ":" + name;
        Set<String> domains = this.m_domains.get(key);
        if (domains == null) {
            domains = new HashSet<String>();
            try {
                List<HourlyReport> reports = this.m_hourlyReportDao.findAllByPeriodName(date, name, HourlyReportEntity.READSET_DOMAIN_NAME);
                if (reports != null) {
                    for (HourlyReport report : reports) {
                        domains.add(report.getDomain());
                    }
                }
                Cat.logEvent((String)"FindDomain", (String)key, (String)"0", (String)domains.toString());
                this.m_domains.put(key, domains);
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
            }
        }
        return domains;
    }

    @Override
    public abstract T queryDailyReport(String var1, Date var2, Date var3);

    @Override
    public abstract T queryHourlyReport(String var1, Date var2, Date var3);

    @Override
    public abstract T queryMonthlyReport(String var1, Date var2);

    @Override
    public T queryReport(String domain, Date start, Date end) {
        int type = this.computeQueryType(start, end);
        T report = null;
        report = type == 1 ? (T)this.queryHourlyReport(domain, start, end) : (type == 2 ? (T)this.queryDailyReport(domain, start, end) : (type == 3 ? (T)this.queryWeeklyReport(domain, start) : (type == 4 ? (T)this.queryMonthlyReport(domain, start) : (T)this.queryDailyReport(domain, start, end))));
        if (report == null) {
            report = this.makeReport(domain, start, end);
        }
        return report;
    }

    @Override
    public abstract T queryWeeklyReport(String var1, Date var2);
}

