/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.service;

import com.dianping.cat.report.service.ModelPeriod;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelRequest {
    private String m_domain;
    private long m_startTime;
    private ModelPeriod m_period;
    private Map<String, String> m_properties = new LinkedHashMap<String, String>();

    public ModelRequest(String domain, long startTime) {
        this.m_domain = domain;
        this.m_startTime = startTime;
        this.m_period = ModelPeriod.getByTime(startTime);
    }

    public ModelRequest(String domain, ModelPeriod period) {
        this.m_domain = domain;
        this.m_period = period;
        this.m_startTime = period.getStartTime();
    }

    public String getDomain() {
        return this.m_domain;
    }

    public ModelPeriod getPeriod() {
        return this.m_period;
    }

    public Map<String, String> getProperties() {
        return this.m_properties;
    }

    public String getProperty(String name) {
        return this.getProperty(name, null);
    }

    public String getProperty(String name, String defaultValue) {
        if (this.m_properties.containsKey(name)) {
            return this.m_properties.get(name);
        }
        return defaultValue;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public ModelRequest setProperty(String name, String value) {
        this.m_properties.put(name, value);
        return this;
    }

    public String toString() {
        return String.format("ModelRequest[domain=%s, period=%s, properties=%s]", new Object[]{this.m_domain, this.m_period, this.m_properties});
    }
}

