/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.service;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.core.dal.Project;
import com.dianping.cat.core.dal.ProjectDao;
import com.dianping.cat.core.dal.ProjectEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectService
implements Initializable {
    @Inject
    private ProjectDao m_projectDao;
    @Inject
    private ServerConfigManager m_manager;
    private ConcurrentHashMap<String, String> m_domains = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Project> m_domainToProjects = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Project> m_cmdbToProjects = new ConcurrentHashMap();
    public static final String DEFAULT = "Default";

    public boolean contains(String domain) {
        return this.m_domains.containsKey(domain);
    }

    public Project create() {
        return this.m_projectDao.createLocal();
    }

    public boolean delete(Project project) {
        int id = project.getId();
        String domainName = null;
        for (Map.Entry<String, Project> entry : this.m_domainToProjects.entrySet()) {
            Project pro = entry.getValue();
            if (pro.getId() != id) continue;
            domainName = pro.getDomain();
            break;
        }
        try {
            this.m_projectDao.deleteByPK(project);
            this.m_domainToProjects.remove(domainName);
            this.m_cmdbToProjects.remove(project.getCmdbDomain());
            return true;
        }
        catch (Exception e) {
            Cat.logError((String)"delete project error ", (Throwable)e);
            return false;
        }
    }

    public List<Project> findAll() throws DalException {
        return new ArrayList<Project>(this.m_domainToProjects.values());
    }

    public Project findByDomain(String domainName) {
        Project project = this.m_domainToProjects.get(domainName);
        if (project != null) {
            return project;
        }
        try {
            Project pro = this.m_projectDao.findByDomain(domainName, ProjectEntity.READSET_FULL);
            this.m_domainToProjects.put(pro.getDomain(), pro);
            return project;
        }
        catch (DalException pro) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return null;
    }

    public Map<String, Department> findDepartments(Collection<String> domains) {
        TreeMap<String, Department> departments = new TreeMap<String, Department>();
        for (String domain : domains) {
            Department temp;
            Project project = this.findProject(domain);
            String department = DEFAULT;
            String projectLine = DEFAULT;
            if (project != null) {
                String bu = project.getBu();
                String productline = project.getCmdbProductline();
                department = bu == null ? DEFAULT : bu;
                String string = projectLine = productline == null ? DEFAULT : productline;
            }
            if ((temp = (Department)departments.get(department)) == null) {
                temp = new Department();
                departments.put(department, temp);
            }
            temp.findOrCreatProjectLine(projectLine).addDomain(domain);
        }
        return departments;
    }

    public Project findProject(String domain) {
        Project project = this.m_domainToProjects.get(domain);
        if (project == null) {
            project = this.m_cmdbToProjects.get(domain);
        }
        return project;
    }

    public void initialize() throws InitializationException {
        if (!this.m_manager.isLocalMode()) {
            this.refresh();
        }
    }

    public boolean insert(Project project) throws DalException {
        this.m_domainToProjects.put(project.getDomain(), project);
        int result = this.m_projectDao.insert(project);
        return result == 1;
    }

    public boolean insert(String domain) {
        Project project = this.create();
        project.setDomain(domain);
        project.setCmdbProductline(DEFAULT);
        project.setBu(DEFAULT);
        try {
            this.insert(project);
            this.m_domains.put(domain, domain);
            return true;
        }
        catch (Exception ex) {
            Cat.logError((Throwable)ex);
            return false;
        }
    }

    protected void refresh() {
        try {
            List<Project> projects = this.m_projectDao.findAll(ProjectEntity.READSET_FULL);
            ConcurrentHashMap<String, Project> tmpDomainProjects = new ConcurrentHashMap<String, Project>();
            ConcurrentHashMap<String, Project> tmpCmdbProjects = new ConcurrentHashMap<String, Project>();
            ConcurrentHashMap<String, String> tmpDomains = new ConcurrentHashMap<String, String>();
            for (Project project : projects) {
                String domain = project.getDomain();
                tmpDomains.put(domain, domain);
                tmpDomainProjects.put(domain, project);
                String cmdb = project.getCmdbDomain();
                if (cmdb == null) continue;
                tmpCmdbProjects.put(cmdb, project);
            }
            this.m_domains = tmpDomains;
            this.m_domainToProjects = tmpDomainProjects;
            this.m_cmdbToProjects = tmpCmdbProjects;
        }
        catch (DalException e) {
            Cat.logError((String)"initialize ProjectService error", (Throwable)e);
        }
    }

    public boolean update(Project project) {
        this.m_domainToProjects.put(project.getDomain(), project);
        try {
            this.m_projectDao.updateByPK(project, ProjectEntity.UPDATESET_FULL);
            return true;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProjectLine {
        private List<String> m_lineDomains = new ArrayList<String>();

        public void addDomain(String name) {
            this.m_lineDomains.add(name);
        }

        public List<String> getLineDomains() {
            return this.m_lineDomains;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Department {
        private Map<String, ProjectLine> m_projectLines = new TreeMap<String, ProjectLine>();

        public ProjectLine findOrCreatProjectLine(String projectLine) {
            ProjectLine line = this.m_projectLines.get(String.valueOf(projectLine));
            if (line == null) {
                line = new ProjectLine();
                this.m_projectLines.put(projectLine, line);
            }
            return line;
        }

        public Map<String, ProjectLine> getProjectLines() {
            return this.m_projectLines;
        }
    }
}

