/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.converter.basic;

import java.lang.reflect.Type;
import org.unidal.converter.Converter;
import org.unidal.converter.ConverterException;
import org.unidal.converter.TypeUtil;

public class LongConverter
implements Converter<Long> {
    @Override
    public boolean canConvert(Type fromType, Type targetType) {
        return TypeUtil.isTypeSupported(fromType, new Type[]{Number.class, Boolean.TYPE, Boolean.class, String.class, Enum.class});
    }

    @Override
    public Long convert(Object from, Type targetType) throws ConverterException {
        if (from instanceof Number) {
            return ((Number)from).longValue();
        }
        if (from instanceof Boolean) {
            return (Boolean)from != false ? Long.valueOf(1L) : 0L;
        }
        if (from instanceof Enum) {
            return ((Enum)from).ordinal();
        }
        try {
            return Long.valueOf(from.toString());
        }
        catch (NumberFormatException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public Type getTargetType() {
        return Long.class;
    }
}

