/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.locks.ReentrantLock;
import org.unidal.helper.Properties;
import org.unidal.helper.Threads;
import org.unidal.lookup.logging.AbstractLogger;
import org.unidal.lookup.logging.Logger;
import org.unidal.lookup.logging.TimedConsoleLoggerManager;

public class TimedConsoleLogger
extends AbstractLogger
implements Logger {
    private MessageFormat m_format;
    private ReentrantLock m_lock = new ReentrantLock();
    private String m_logFilePattern;
    private BufferedWriter m_writer;
    private MessageFormat m_logFileFormat;
    private String m_lastPath;
    private boolean m_showClass;
    private boolean m_devMode;
    private String m_baseDirRef;
    private String m_defaultBaseDir;

    public TimedConsoleLogger(int threshold, String name, String dateFormat, String logFilePattern, boolean showClass, boolean devMode) {
        super(threshold, name);
        String pattern = showClass ? "[{0,date," + dateFormat + "}] [{1}] [{3}] {2}" : "[{0,date," + dateFormat + "}] [{1}] {2}";
        this.m_showClass = showClass;
        this.m_format = new MessageFormat(pattern);
        this.m_logFilePattern = logFilePattern;
        this.m_devMode = devMode;
        if (logFilePattern != null && logFilePattern.indexOf("{0,") >= 0) {
            this.m_logFileFormat = new MessageFormat(logFilePattern);
            this.m_logFileFormat.format(new Object[]{new Date()});
        }
    }

    @Override
    public void debug(String message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.out("DEBUG", message, throwable);
        }
    }

    @Override
    public void error(String message, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.out("ERROR", message, throwable);
        }
    }

    private String getCallerClassName() {
        String caller = Threads.getCallerClass();
        if (caller != null) {
            return caller;
        }
        StackTraceElement[] elements = new Exception().getStackTrace();
        if (elements.length > 5) {
            for (int i = 5; i < elements.length; ++i) {
                String className = elements[i].getClassName();
                if (TimedConsoleLoggerManager.shouldSkipClass(className)) continue;
                int pos = className.lastIndexOf(36);
                if (pos < 0) {
                    pos = className.lastIndexOf(46);
                }
                if (pos > 0) {
                    return className.substring(pos + 1);
                }
                return className;
            }
        }
        return "N/A";
    }

    private File getFilePath(String path) throws IOException {
        File file = new File(path);
        String baseDir = Properties.forString().fromSystem().fromEnv().getProperty(this.m_baseDirRef, this.m_defaultBaseDir);
        if (baseDir != null) {
            file = new File(baseDir, path);
        }
        return file.getCanonicalFile();
    }

    private String getTimedMessage(String level, String message) {
        if (this.m_showClass) {
            return this.m_format.format(new Object[]{new Date(), level, message, this.getCallerClassName()});
        }
        return this.m_format.format(new Object[]{new Date(), level, message});
    }

    private BufferedWriter getWriter() throws IOException {
        if (this.m_logFileFormat != null) {
            String path = this.m_logFileFormat.format(new Object[]{new Date()});
            if (!path.equals(this.m_lastPath)) {
                if (this.m_writer != null) {
                    try {
                        this.m_writer.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                File file = this.getFilePath(path);
                file.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(file, true);
                System.out.println("Logger file " + file.getPath());
                this.m_writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "utf-8"));
                this.m_lastPath = path;
            }
        } else if (this.m_writer == null) {
            File file = this.getFilePath(this.m_logFilePattern);
            file.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(file, true);
            System.out.println("Logger file " + file.getPath());
            this.m_writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "utf-8"));
            this.m_lastPath = this.m_logFilePattern;
        }
        return this.m_writer;
    }

    @Override
    public void info(String message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.out("INFO", message, throwable);
        }
    }

    private boolean isDevMode() {
        String mode = System.getProperty("devMode", "false");
        if ("true".equals(mode)) {
            return true;
        }
        return this.m_devMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void out(String severity, String message, Throwable throwable) {
        this.m_lock.lock();
        try {
            String timedMessage = this.getTimedMessage(severity, message);
            if (this.isDevMode() || this.m_logFilePattern == null || this.m_logFilePattern.length() == 0) {
                System.out.println(timedMessage);
                if (throwable != null) {
                    throwable.printStackTrace(System.out);
                }
            } else {
                try {
                    BufferedWriter writer = this.getWriter();
                    writer.write(timedMessage);
                    writer.newLine();
                    if (throwable != null) {
                        throwable.printStackTrace(new PrintWriter(writer));
                    }
                    writer.flush();
                }
                catch (Exception e) {
                    System.out.println(this.getTimedMessage("ERROR", e.toString()));
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    public void setBaseDirRef(String baseDirRef) {
        this.m_baseDirRef = baseDirRef;
    }

    public void setDefaultBaseDir(String defaultBaseDir) {
        this.m_defaultBaseDir = defaultBaseDir;
    }

    @Override
    public void warn(String message, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.out("WARN", message, throwable);
        }
    }
}

