package com.reyun.controller.manage;

import com.reyun.model.AccountRestrict4Web;
import com.reyun.repository.AccountRepository;
import com.reyun.repository.AccountRestrict4WebRepository;
import com.reyun.service.AccountFlowRestrictService;
import com.reyun.util.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

/**
 * Created by song on 2017/10/19.
 */

@Controller
@RequestMapping("/mng/accountRestrict")
public class MngAccountFlowController {

    @Autowired
    private AccountRestrict4WebRepository accountRestrict4WebRepository;
    @Autowired
    private AccountRepository accountRepository;
    @Autowired
    private AccountFlowRestrictService accountFlowRestrictService;

    @RequestMapping(value = "find/{accountId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel list(@PathVariable Long accountId) {
        long superAccountId = accountRepository.findRootParentByAccountId(accountId).longValue();
        AccountRestrict4Web byAccountId = accountRestrict4WebRepository.findByAccountId(superAccountId);
        if(byAccountId==null){
            byAccountId = accountFlowRestrictService.RestrictFlowByAccountTask(accountId);
        }
        return ResultModel.OK(byAccountId);
    }

    @RequestMapping(value = "confirm", method = RequestMethod.POST)
    @ResponseBody
    public ResultModel confirm(@RequestBody AccountRestrict4Web resource) {
        long superAccountId = accountRepository.findRootParentByAccountId(resource.getAccountId()).longValue();
        AccountRestrict4Web byAccountId1 = accountRestrict4WebRepository.findByAccountId(superAccountId);
        if(resource.getTrackPastTime()!=null && resource.getTrackPastTime()){
            byAccountId1.setTrackPastTimeNotified(false);
        }
        if(resource.getIoPastTime()!=null && resource.getIoPastTime()){
            byAccountId1.setIOPastTimeNotified(false);
        }
        if(resource.getTrackFlow()!=null && resource.getTrackFlow()){
            byAccountId1.setTrackFlowNotified(false);
        }
        if(resource.getIoFlow()!=null && resource.getIoFlow() ){
            byAccountId1.setIOFlowNotified(false);
        }
        accountRestrict4WebRepository.save(byAccountId1);
        return ResultModel.OK();
    }
}
